/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.base;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class MetaAttributeDef {
    private String mName;
    private ObjectIdentifier mOid;
    private Class<?> mValueClass;
    private static Hashtable<String, MetaAttributeDef> mNameToAttrDef = new Hashtable();
    private static Hashtable<ObjectIdentifier, MetaAttributeDef> mOidToAttrDef = new Hashtable();

    private MetaAttributeDef() {
    }

    private MetaAttributeDef(String name, Class<?> valueClass, ObjectIdentifier oid) {
        this.mName = name;
        this.mValueClass = valueClass;
        this.mOid = oid;
    }

    public ObjectIdentifier getOID() {
        return this.mOid;
    }

    public Class<?> getValueClass() {
        return this.mValueClass;
    }

    public String getName() {
        return this.mName;
    }

    public static MetaAttributeDef register(String name, Class<?> valueClass, ObjectIdentifier oid) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("Attribute value class must not be null");
        }
        MetaAttributeDef newDef = new MetaAttributeDef(name, valueClass, oid);
        MetaAttributeDef oldDef = mNameToAttrDef.get(name);
        if (oldDef != null && !oldDef.equals(newDef)) {
            throw new IllegalArgumentException("Attribute '" + name + "' is already defined");
        }
        if (oid != null && (oldDef = mOidToAttrDef.get(oid)) != null && !oldDef.equals(newDef)) {
            throw new IllegalArgumentException("OID '" + oid + "' is already in use");
        }
        mNameToAttrDef.put(name, newDef);
        if (oid != null) {
            mOidToAttrDef.put(oid, newDef);
        }
        return newDef;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mOid == null ? 0 : this.mOid.hashCode());
        result = 31 * result + (this.mValueClass == null ? 0 : this.mValueClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaAttributeDef other = (MetaAttributeDef)obj;
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.mOid == null ? other.mOid != null : !this.mOid.equals(other.mOid)) {
            return false;
        }
        return !(this.mValueClass == null ? other.mValueClass != null : !this.mValueClass.equals(other.mValueClass));
    }

    public static MetaAttributeDef forName(String name) {
        return mNameToAttrDef.get(name);
    }

    public static MetaAttributeDef forOID(ObjectIdentifier oid) {
        return mOidToAttrDef.get(oid);
    }

    public static Enumeration<String> getAttributeNames() {
        return mNameToAttrDef.keys();
    }

    public static Enumeration<ObjectIdentifier> getAttributeNameOids() {
        return mOidToAttrDef.keys();
    }
}

