/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.user;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.user.UserCertCollection;
import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserCollection;
import com.netscape.certsrv.user.UserData;
import com.netscape.certsrv.user.UserMembershipCollection;
import com.netscape.certsrv.user.UserMembershipData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class UserClient
extends Client {
    public UserClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "admin/users");
    }

    public UserClient(SubsystemClient subsystemClient) throws Exception {
        this(subsystemClient.client, subsystemClient.getName());
    }

    public UserCollection findUsers(String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, UserCollection.class);
    }

    public UserData getUser(String userID) throws Exception {
        return this.get(userID, UserData.class);
    }

    public UserData addUser(UserData userData) throws Exception {
        Entity<UserData> entity = this.client.entity(userData);
        return this.post(null, null, entity, UserData.class);
    }

    public UserData modifyUser(String userID, UserData userData) throws Exception {
        Entity<UserData> entity = this.client.entity(userData);
        return this.patch(userID, null, entity, UserData.class);
    }

    public void removeUser(String userID) throws Exception {
        this.delete(userID, Void.class);
    }

    public UserCertCollection findUserCerts(String userID, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(userID + "/certs", params, UserCertCollection.class);
    }

    public UserCertData getUserCert(String userID, String certID) throws Exception {
        return this.get(userID + "/certs/" + certID, UserCertData.class);
    }

    public UserCertData addUserCert(String userID, UserCertData userCertData) throws Exception {
        Entity<UserCertData> entity = this.client.entity(userCertData);
        return this.post(userID + "/certs", null, entity, UserCertData.class);
    }

    public void removeUserCert(String userID, String certID) throws Exception {
        this.delete(userID + "/certs/" + certID, Void.class);
    }

    public UserMembershipCollection findUserMemberships(String userID, String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(userID + "/memberships", params, UserMembershipCollection.class);
    }

    public UserMembershipData addUserMembership(String userID, String groupID) throws Exception {
        Entity<String> entity = this.client.entity(groupID);
        return this.post(userID + "/memberships", null, entity, UserMembershipData.class);
    }

    public void removeUserMembership(String userD, String groupID) throws Exception {
        this.delete(userD + "/memberships/" + groupID, Void.class);
    }
}

