/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncLoader {
    private CountDownLatch producerInitialised = new CountDownLatch(1);
    private GoAwayLock loadingLock = new GoAwayLock();
    private Integer numItems = null;
    private int numItemsLoaded = 0;
    private boolean loading = true;
    private int timeoutSeconds = 0;
    private Timer timer = new Timer("AsyncLoader watchdog");
    private TimerTask watchdog = null;

    public AsyncLoader(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void startLoading() {
        this.loadingLock.lock();
        this.loading = true;
        this.numItems = null;
        this.numItemsLoaded = 0;
        this.producerInitialised.countDown();
        if (this.timeoutSeconds > 0) {
            if (this.watchdog != null) {
                this.watchdog.cancel();
            }
            this.watchdog = new AsyncLoaderWatchdog();
            this.timer.schedule(this.watchdog, this.timeoutSeconds * 1000);
        }
    }

    public void increment() {
        if (this.loading) {
            ++this.numItemsLoaded;
            this.checkLoadDone();
        }
    }

    public void setNumItems(Integer n) {
        this.numItems = n;
        this.checkLoadDone();
    }

    private void checkLoadDone() {
        if (this.numItems != null && this.numItemsLoaded >= this.numItems) {
            this.watchdog.cancel();
            this.loading = false;
            while (this.loadingLock.isHeldByCurrentThread()) {
                this.loadingLock.unlock();
            }
        }
    }

    public void awaitLoadDone() throws InterruptedException {
        if (this.loading) {
            this.producerInitialised.await();
            this.loadingLock.lockInterruptibly();
            this.loadingLock.unlock();
        }
    }

    private void forceUnlock() {
        this.loading = false;
        this.loadingLock.interruptWaitingThreads();
    }

    public void shutdown() {
        this.timer.cancel();
    }

    private static class GoAwayLock
    extends ReentrantLock {
        private GoAwayLock() {
        }

        public void interruptWaitingThreads() {
            for (Thread thread : this.getQueuedThreads()) {
                thread.interrupt();
            }
        }
    }

    private class AsyncLoaderWatchdog
    extends TimerTask {
        private AsyncLoaderWatchdog() {
        }

        @Override
        public void run() {
            AsyncLoader.this.forceUnlock();
        }
    }
}

