/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.TBSRequest;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPProcessor {
    public static Logger logger = LoggerFactory.getLogger(OCSPProcessor.class);
    public String url;

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public OCSPRequest createRequest(byte[] data) throws Exception {
        OCSPRequest.Template template = new OCSPRequest.Template();
        return (OCSPRequest)template.decode(new ByteArrayInputStream(data));
    }

    public OCSPRequest createRequest(String caNickname, BigInteger serialNumber) throws Exception {
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate caCert = manager.findCertByNickname(caNickname);
        X509CertImpl cert = new X509CertImpl(caCert.getEncoded());
        X500Name issuerName = cert.getSubjectName();
        X509Key issuerKey = (X509Key)cert.getPublicKey();
        return this.createRequest(issuerName, issuerKey, serialNumber);
    }

    public OCSPRequest createRequest(X500Name issuerName, X509Key issuerKey, BigInteger serialNumber) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] issuerNameHash = md.digest(issuerName.getEncoded());
        byte[] issuerKeyHash = md.digest(issuerKey.getKey());
        CertID certID = new CertID(new AlgorithmIdentifier(new OBJECT_IDENTIFIER("1.3.14.3.2.26"), (ASN1Value)new NULL()), new OCTET_STRING(issuerNameHash), new OCTET_STRING(issuerKeyHash), new INTEGER(serialNumber));
        Request request = new Request(certID, null);
        SEQUENCE requestList = new SEQUENCE();
        requestList.addElement((ASN1Value)request);
        TBSRequest tbsRequest = new TBSRequest(null, null, requestList, null);
        return new OCSPRequest(tbsRequest, null);
    }

    public OCSPResponse submitRequest(OCSPRequest request) throws Exception {
        return this.submitRequest(this.url, request);
    }

    /*
     * Exception decompiling
     */
    public OCSPResponse submitRequest(String url, OCSPRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

