/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EERequestFilter
implements Filter {
    public static Logger logger = LoggerFactory.getLogger(EERequestFilter.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTP_PORT = "http_port";
    private static final String HTTP_ROLE = "EE";
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTPS_PORT = "https_port";
    private static final String HTTPS_ROLE = "EE";
    private static final String PROXY_PORT = "proxy_port";
    private static final String PROXY_HTTP_PORT = "proxy_http_port";
    private FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block16: {
            boolean bad_port;
            HttpServletResponse resp;
            String param_active;
            Object msg;
            String param_proxy_port;
            String param_https_port;
            String request_port;
            String scheme;
            String filterName;
            block17: {
                filterName = this.getClass().getName();
                scheme = null;
                int port = 0;
                request_port = null;
                String param_http_port = null;
                param_https_port = null;
                param_proxy_port = null;
                String param_proxy_http_port = null;
                msg = null;
                param_active = null;
                param_active = this.config.getInitParameter("active");
                if (!(request instanceof HttpServletRequest)) break block16;
                resp = (HttpServletResponse)response;
                scheme = request.getScheme();
                if (!scheme.equals(HTTP_SCHEME) && !scheme.equals(HTTPS_SCHEME)) {
                    msg = "The scheme MUST be either 'http' or 'https', NOT '" + scheme + "'!";
                    logger.error(filterName + ":  " + (String)msg);
                    resp.sendError(401, (String)msg);
                    return;
                }
                port = request.getLocalPort();
                request_port = Integer.toString(port);
                param_http_port = this.config.getInitParameter(HTTP_PORT);
                if (param_http_port == null) {
                    msg = "The <param-name> 'http_port' </param-name> MUST be specified in 'web.xml'!";
                    logger.error(filterName + ":  " + (String)msg);
                    resp.sendError(501, (String)msg);
                    return;
                }
                param_https_port = this.config.getInitParameter(HTTPS_PORT);
                if (param_https_port == null) {
                    msg = "The <param-name> 'https_port' </param-name> MUST be specified in 'web.xml'!";
                    logger.error(filterName + ":  " + (String)msg);
                    resp.sendError(501, (String)msg);
                    return;
                }
                param_proxy_http_port = this.config.getInitParameter(PROXY_HTTP_PORT);
                param_proxy_port = this.config.getInitParameter(PROXY_PORT);
                bad_port = false;
                if (!scheme.equals(HTTP_SCHEME)) break block17;
                if (param_http_port.equals(request_port)) break block16;
                String uri = ((HttpServletRequest)request).getRequestURI();
                if (param_proxy_http_port != null) {
                    if (!param_proxy_http_port.equals(request_port)) {
                        msg = "Use HTTP port '" + param_http_port + "' or proxy port '" + param_proxy_http_port + "' instead of '" + request_port + "' when performing EE tasks!";
                        bad_port = true;
                    }
                } else {
                    msg = "Use HTTP port '" + param_http_port + "' instead of '" + request_port + "' when performing EE tasks!";
                    bad_port = true;
                }
                if (bad_port) {
                    logger.error(filterName + ":  " + (String)msg);
                    logger.debug(filterName + ": uri is " + uri);
                    if (param_active != null && param_active.equals("false")) {
                        logger.debug("Filter is disabled .. continuing");
                        break block16;
                    } else {
                        resp.sendError(404, (String)msg);
                        return;
                    }
                }
                break block16;
            }
            if (scheme.equals(HTTPS_SCHEME) && !param_https_port.equals(request_port)) {
                String uri = ((HttpServletRequest)request).getRequestURI();
                if (param_proxy_port != null) {
                    if (!param_proxy_port.equals(request_port)) {
                        msg = "Use HTTPS port '" + param_https_port + "' or proxy port '" + param_proxy_port + "' instead of '" + request_port + "' when performing EE tasks!";
                        bad_port = true;
                    }
                } else {
                    msg = "Use HTTPS port '" + param_https_port + "' instead of '" + request_port + "' when performing EE tasks!";
                    bad_port = true;
                }
                if (bad_port) {
                    logger.error(filterName + ":  " + (String)msg);
                    logger.debug(filterName + ": uri is " + uri);
                    if (param_active != null && param_active.equals("false")) {
                        logger.debug("Filter is disabled .. continuing");
                    } else {
                        resp.sendError(404, (String)msg);
                        return;
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

