/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessReq
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ProcessReq.class);
    protected static final String SEQNUM = "seqNum";
    protected static final String DO_ASSIGN = "doAssign";
    protected static final String TPL_FILE = "processReq.template";
    protected static final String PROP_PARSER = "parser";
    protected String mFormPath;
    protected ReqParser mParser;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/" + this.mAuthority.getId() + "/processReq.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mTemplates.remove(CMSRequest.ERROR);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        CMSTemplate form;
        EBaseException error;
        CMSTemplateParams argSet;
        HttpServletResponse resp;
        HttpServletRequest req;
        block22: {
            BigInteger seqNum = BigInteger.ONE.negate();
            req = cmsReq.getHttpReq();
            resp = cmsReq.getHttpResp();
            AuthToken authToken = this.authenticate(cmsReq);
            ArgBlock header = new ArgBlock();
            ArgBlock fixed = new ArgBlock();
            argSet = new CMSTemplateParams(header, fixed);
            String doAssign = null;
            error = null;
            form = null;
            Locale[] locale = new Locale[1];
            try {
                form = this.getTemplate(this.mFormPath, req, locale);
            }
            catch (IOException e) {
                logger.error("ProcessReq: Unable to get template " + this.mFormPath + ": " + e.getMessage(), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
            }
            try {
                if (req.getParameter(SEQNUM) != null) {
                    seqNum = new BigInteger(req.getParameter(SEQNUM));
                }
                doAssign = req.getParameter(DO_ASSIGN);
                if (seqNum.compareTo(BigInteger.ONE.negate()) > 0) {
                    AuthzToken authzToken = null;
                    try {
                        if (doAssign == null) {
                            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
                        } else if (doAssign.equals("toMe") || doAssign.equals("reassignToMe")) {
                            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "assign");
                        } else if (doAssign.equals("reassignToNobody")) {
                            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "unassign");
                        }
                    }
                    catch (EAuthzAccessDenied e) {
                        logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
                    }
                    if (authzToken == null) {
                        cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                        return;
                    }
                    this.process(argSet, header, seqNum, req, resp, doAssign, locale[0]);
                    break block22;
                }
                logger.warn("ProcessReq: Invalid sequence number " + seqNum);
                error = new ECMSGWException(CMS.getUserMessage("CMS_GW_INVALID_REQUEST_ID", String.valueOf(seqNum)));
            }
            catch (EBaseException e) {
                error = e;
            }
            catch (NumberFormatException e) {
                error = new EBaseException(CMS.getUserMessage(locale[0], "CMS_BASE_INVALID_NUMBER_FORMAT", new String[0]));
            }
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setError(error);
                cmsReq.setStatus(CMSRequest.ERROR);
            }
        }
        catch (IOException e) {
            logger.error("ProcessReq: Error getting servlet output stream for rendering template: " + e.getMessage(), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
    }

    public void addAuthorityName(ArgBlock header) throws EBaseException {
    }

    public void addSigningAlgorithm(ArgBlock header) throws EBaseException {
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, BigInteger seqNum, HttpServletRequest req, HttpServletResponse resp, String doAssign, Locale locale) throws EBaseException {
        header.addBigIntegerValue(SEQNUM, seqNum, 10);
        Request r = this.requestRepository.readRequest(new RequestId(seqNum));
        if (r != null) {
            if (doAssign != null) {
                if (doAssign.equals("toMe") || doAssign.equals("reassignToMe")) {
                    SessionContext ctx = SessionContext.getContext();
                    String id = (String)ctx.get((Object)"userid");
                    r.setRequestOwner(id);
                    this.requestRepository.updateRequest(r);
                } else if (doAssign.equals("reassignToNobody")) {
                    r.setRequestOwner(null);
                    this.requestRepository.updateRequest(r);
                }
            }
        } else {
            logger.error("ProcessReq: Invalid sequence number " + seqNum.toString());
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_INVALID_REQUEST_ID", seqNum.toString()));
        }
        this.addAuthorityName(header);
        this.addSigningAlgorithm(header);
        this.mParser.fillRequestIntoArg(locale, r, argSet, header);
    }
}

