/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.authentication.IPasswdUserDBAuthentication;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.ldapconn.LdapAnonConnFactory;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.util.Enumeration;
import java.util.Locale;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswdUserDBAuthentication
extends AuthManager
implements IPasswdUserDBAuthentication {
    public static Logger logger = LoggerFactory.getLogger(PasswdUserDBAuthentication.class);
    protected static String[] mRequiredCred = new String[]{"uid", "pwd"};
    private LdapAnonConnFactory mAnonConnFactory = null;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        EngineConfig cs = this.engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        DBSubsystem dbSubsystem = this.engine.getDBSubsystem();
        LdapConnInfo ldapinfo = dbSubsystem.getLdapConnInfo();
        this.mAnonConnFactory = new LdapAnonConnFactory("PasswdUserDBAuthentication", 3, 20, ldapinfo);
        this.mAnonConnFactory.setCMSEngine(this.engine);
        this.mAnonConnFactory.init(socketConfig);
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        User user;
        AuthToken authToken = new AuthToken(this);
        String uid = (String)authCred.get("uid");
        logger.info("PasswdUserDBAuthentication: authenticating UID: " + uid);
        if (uid == null) {
            logger.error(CMS.getLogMessage("CMSCORE_AUTH_MISSING_UID", new Object[0]));
            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", "uid"));
        }
        String pwd = (String)authCred.get("pwd");
        if (pwd == null) {
            logger.error(CMS.getLogMessage("CMSCORE_AUTH_ADMIN_NULL_PW", uid));
            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", "pwd"));
        }
        if (pwd.equals("")) {
            logger.error(CMS.getLogMessage("CMSCORE_AUTH_ADMIN_EMPTY_PW", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        UGSubsystem ug = this.engine.getUGSubsystem();
        try {
            user = ug.getUser(uid);
        }
        catch (EBaseException e) {
            logger.error("Unable to authenticate user: " + e.getMessage(), (Throwable)e);
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]) + " " + e.getMessage(), (Exception)((Object)e));
        }
        if (user == null) {
            logger.error("PasswdUserDBAuthentication: User not found: " + uid);
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", "Failure in User Group subsystem."));
        }
        String userdn = user.getUserDN();
        logger.info("PasswdUserDBAuthentication: DN: " + userdn);
        LDAPConnection anonConn = null;
        try {
            anonConn = this.mAnonConnFactory.getConn();
            anonConn.authenticate(userdn, pwd);
        }
        catch (LDAPException e) {
            logger.error(CMS.getLogMessage("CMSCORE_AUTH_AUTH_FAILED", uid, e.toString()), (Throwable)e);
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]), (Exception)((Object)e));
        }
        finally {
            if (anonConn != null) {
                this.mAnonConnFactory.returnConn(anonConn);
            }
        }
        authToken.set("userdn", userdn);
        authToken.set("uid", uid);
        authToken.set("userdn", user.getUserDN());
        authToken.set("userid", user.getUserID());
        logger.info(CMS.getLogMessage("CMS_AUTH_AUTHENTICATED", uid));
        return authToken;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    @Override
    public String getText(Locale locale) {
        return null;
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    @Override
    public String[] getRequiredCreds() {
        return mRequiredCred;
    }

    @Override
    public void shutdown() {
        try {
            if (this.mAnonConnFactory != null) {
                this.mAnonConnFactory.reset();
            }
        }
        catch (ELdapException e) {
            logger.error("Unable to disconnect LDAP connections: " + e.getMessage(), (Throwable)e);
        }
    }
}

