/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.DirStrConverter;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X500NameSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(X500NameSubsystem.class);
    private ConfigStore mConfig;
    public static final String ID = "X500Name";
    private String mId = "X500Name";
    private static final String PROP_DIR_STR_ENCODING_ORDER = "directoryStringEncodingOrder";
    private static final String PROP_ATTR = "attr";
    private static final String PROP_OID = "oid";
    private static final String PROP_CLASS = "class";
    private static String PRINTABLESTRING = "PrintableString";
    private static String IA5STRING = "IA5String";
    private static String VISIBLESTRING = "VisibleString";
    private static String T61STRING = "T61String";
    private static String BMPSTRING = "BMPString";
    private static String UNIVERSALSTRING = "UniversalString";
    private static String UFT8STRING = "UTF8String";
    private static Hashtable<String, Byte> mDerStr2TagHash = new Hashtable();

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    @Override
    public synchronized void init(ConfigStore config) throws Exception {
        logger.trace("X500Name started");
        this.mConfig = config;
        this.setDirStrEncodingOrder();
        this.loadX500NameAttrMaps();
    }

    private void loadX500NameAttrMaps() throws EBaseException {
        X500NameAttrMap globalMap = X500NameAttrMap.getDefault();
        ConfigStore attrSubStore = this.mConfig.getSubStore(PROP_ATTR, ConfigStore.class);
        Enumeration<String> attrNames = attrSubStore.getSubStoreNames().elements();
        while (attrNames.hasMoreElements()) {
            String name = attrNames.nextElement();
            ConfigStore substore = attrSubStore.getSubStore(name, ConfigStore.class);
            String oidString = substore.getString(PROP_OID);
            ObjectIdentifier oid = CertUtils.checkOID(name, oidString);
            String className = substore.getString(PROP_CLASS);
            AVAValueConverter convClass = null;
            try {
                convClass = (AVAValueConverter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_LOAD_CLASS_FAILED", className, e.toString()), (Throwable)e);
            }
            globalMap.addNameOID(name, oid, convClass);
            logger.trace("X500Name: Loaded " + name + " " + oid + " " + className);
        }
    }

    private void setDirStrEncodingOrder() throws EBaseException {
        String method = "X500NameSubsystem: setDirStrEncodingOrder: ";
        String order = this.mConfig.getString(PROP_DIR_STR_ENCODING_ORDER, null);
        if (order == null || order.length() == 0) {
            logger.debug(method + "X500Name.directoryStringEncodingOrder not specified in config; Using default order in DirStrConverter.");
            return;
        }
        logger.debug(method + "X500Name.directoryStringEncodingOrder specified in config: " + order);
        StringTokenizer toker = new StringTokenizer(order, ", \t");
        int numTokens = toker.countTokens();
        if (numTokens == 0) {
            String msg = "must be a list of DER tag names seperated by commas.";
            logger.error(CMS.getLogMessage("CMSCORE_CERT_DIR_STRING", PROP_DIR_STR_ENCODING_ORDER));
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", PROP_DIR_STR_ENCODING_ORDER, msg));
        }
        byte[] tags = new byte[numTokens];
        int i = 0;
        while (toker.hasMoreTokens()) {
            String nextTag = toker.nextToken();
            try {
                tags[i] = this.derStr2Tag(nextTag);
            }
            catch (IllegalArgumentException e) {
                String msg = "unknown DER tag '" + nextTag + "'.";
                logger.error(CMS.getLogMessage("CMSCORE_CERT_UNKNOWN_TAG", PROP_DIR_STR_ENCODING_ORDER, nextTag), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", PROP_DIR_STR_ENCODING_ORDER, msg), (Throwable)e);
            }
            ++i;
        }
        DirStrConverter.setDefEncodingOrder((byte[])tags);
    }

    private byte derStr2Tag(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException();
        }
        Byte tag = mDerStr2TagHash.get(s);
        if (tag == null) {
            throw new IllegalArgumentException();
        }
        return tag;
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public synchronized void shutdown() {
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    static {
        mDerStr2TagHash.put(PRINTABLESTRING, (byte)19);
        mDerStr2TagHash.put(IA5STRING, (byte)22);
        mDerStr2TagHash.put(VISIBLESTRING, (byte)26);
        mDerStr2TagHash.put(T61STRING, (byte)20);
        mDerStr2TagHash.put(BMPSTRING, (byte)30);
        mDerStr2TagHash.put(UNIVERSALSTRING, (byte)28);
        mDerStr2TagHash.put(UFT8STRING, (byte)12);
    }
}

