/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.logging;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.logging.ELogException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.logging.LogPlugin;
import com.netscape.cms.logging.LogQueue;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.LoggerConfig;
import com.netscape.cmscore.logging.LoggerPluginsConfig;
import com.netscape.cmscore.logging.LoggersConfig;
import com.netscape.cmscore.logging.LoggingConfig;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(LogSubsystem.class);
    private LoggingConfig mConfig;
    public static final String ID = "log";
    public static final String PROP_CLASS = "class";
    public static final String PROP_PLUGIN = "pluginName";
    public Hashtable<String, LogPlugin> mLogPlugins = new Hashtable();
    public Hashtable<String, LogEventListener> mLogInsts = new Hashtable();
    public Set<String> auditEvents = new TreeSet<String>();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void setId(String id) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
    }

    @Override
    public void init(ConfigStore config) throws Exception {
        this.mConfig = (LoggingConfig)config;
        LogQueue.getInstance().init();
        LoggerPluginsConfig pluginsConfig = this.mConfig.getLoggerPluginsConfig();
        Enumeration<String> mImpls = pluginsConfig.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = mImpls.nextElement();
            String pluginPath = pluginsConfig.getString(id + ".class");
            LogPlugin plugin = new LogPlugin(id, pluginPath);
            this.mLogPlugins.put(id, plugin);
        }
        logger.trace("loaded logger plugins");
        LoggersConfig loggersConfig = this.mConfig.getLoggersConfig();
        Enumeration<String> instances = loggersConfig.getSubStoreNames().elements();
        while (instances.hasMoreElements()) {
            String insName = instances.nextElement();
            String implName = loggersConfig.getString(insName + ".pluginName");
            LogPlugin plugin = this.mLogPlugins.get(implName);
            if (plugin == null) {
                throw new EBaseException(implName);
            }
            String className = plugin.getClassPath();
            LogEventListener logInst = null;
            try {
                logInst = (LogEventListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoggerConfig pConfig = loggersConfig.getSubStore(insName, LoggerConfig.class);
                logInst.setCMSEngine(this.engine);
                logInst.init(this, pConfig);
            }
            catch (EBaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EBaseException(insName + ": Unable to create " + className + ": " + e.getMessage(), (Throwable)e);
            }
            this.mLogInsts.put(insName, logInst);
            logger.trace("loaded log instance " + insName + " impl " + implName);
        }
        ResourceBundle rb = ResourceBundle.getBundle("audit-events");
        Pattern value_pattern = Pattern.compile("^<type=(.*)>:.*");
        for (String name : rb.keySet()) {
            String value = rb.getString(name);
            Matcher value_matcher = value_pattern.matcher(value);
            if (!value_matcher.matches()) continue;
            String event = value_matcher.group(1);
            this.auditEvents.add(event.trim());
        }
    }

    public Collection<String> getAuditEvents() {
        return this.auditEvents;
    }

    @Override
    public void startup() throws EBaseException {
        logger.trace("entering LogSubsystem.startup()");
        Enumeration<String> enum1 = this.mLogInsts.keys();
        while (enum1.hasMoreElements()) {
            String instName = enum1.nextElement();
            logger.trace("about to call inst=" + instName + " in LogSubsystem.startup()");
            LogEventListener inst = this.mLogInsts.get(instName);
            inst.startup();
        }
    }

    @Override
    public void shutdown() {
        LogQueue.getInstance().shutdown();
    }

    @Override
    public LoggingConfig getConfigStore() {
        return this.mConfig;
    }

    public String getLogPluginName(LogEventListener log) {
        ConfigStore cs = log.getConfigStore();
        if (cs == null) {
            return "";
        }
        try {
            return cs.getString(PROP_PLUGIN, "");
        }
        catch (EBaseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public LogEventListener getLogInstance(String insName) {
        return this.mLogInsts.get(insName);
    }

    public Hashtable<String, LogPlugin> getLogPlugins() {
        return this.mLogPlugins;
    }

    public Hashtable<String, LogEventListener> getLogInsts() {
        return this.mLogInsts;
    }

    public Vector<String> getLogDefaultParams(String implName) throws ELogException {
        LogPlugin plugin = this.mLogPlugins.get(implName);
        if (plugin == null) {
            throw new ELogException(implName);
        }
        LogEventListener LogInst = null;
        String className = plugin.getClassPath();
        try {
            LogInst = (LogEventListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Vector<String> v = LogInst.getDefaultParams();
            return v;
        }
        catch (Exception e) {
            throw new ELogException(CMS.getUserMessage("CMS_LOG_LOAD_CLASS_FAIL", className), e);
        }
    }

    public Vector<String> getLogInstanceParams(String insName) throws ELogException {
        LogEventListener logInst = this.getLogInstance(insName);
        if (logInst == null) {
            return null;
        }
        Vector<String> v = logInst.getInstanceParams();
        return v;
    }
}

