/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.util;

import java.io.File;
import java.io.FilenameFilter;

public class FileDialogFilter
implements FilenameFilter {
    String filter;

    public FileDialogFilter(String f) {
        this.filter = f;
    }

    public String toString() {
        return this.filter;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        File f = new File(dir, fileName);
        return f.isDirectory() || this.searchPattern(fileName, this.filter);
    }

    boolean searchPattern(String fileName, String filter) {
        int filterCursor = 0;
        char filterChar = filter.charAt(filterCursor);
        if (filterCursor == 0 && filterChar != '*') {
            return false;
        }
        String ls = filter.substring(filterCursor + 1);
        return this.handleStar(fileName, ls);
    }

    boolean handleStar(String fileName, String filter) {
        char ftChar;
        int ftLen = filter.length();
        int flLen = fileName.length();
        int ftCur = 0;
        int flCur = 0;
        int c = 0;
        if (ftLen == 0) {
            return true;
        }
        while (c < flLen) {
            ftChar = filter.charAt(ftCur);
            if (ftChar == '*') {
                String ls = filter.substring(ftCur + 1);
                String fs = fileName.substring(flCur);
                if (this.handleStar(fs, ls)) {
                    return true;
                }
                flCur = ++c;
                ftCur = 0;
                continue;
            }
            char flChar = fileName.charAt(flCur);
            if (ftChar == flChar) {
                if (++flCur == flLen && ++ftCur == ftLen) {
                    return true;
                }
                if (flCur < flLen && ftCur == ftLen) {
                    return false;
                }
                if (flCur != flLen) continue;
                c = flLen;
                continue;
            }
            flCur = ++c;
            ftCur = 0;
            if (c != flLen) continue;
            return false;
        }
        for (int i = ftCur; i < ftLen; ++i) {
            ftChar = filter.charAt(i);
            if (ftChar == '*') continue;
            return false;
        }
        return true;
    }
}

