/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CommandCLI;

public class SDSubsystemAddCLI
extends CommandCLI {
    public SDSubsystemAddCLI(CLI parent) {
        super("add", "Add security domain subsystem", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "subsystem", true, "Subsystem type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "hostname", true, "Hostname");
        option.setArgName("hostname");
        this.options.addOption(option);
        option = new Option(null, "unsecure-port", true, "Unsecure port (default: 8080)");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option(null, "secure-port", true, "Secure port (default: 8443)");
        option.setArgName("port");
        this.options.addOption(option);
        this.options.addOption(null, "domain-manager", false, "Domain manager");
        this.options.addOption(null, "clone", false, "Clone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new CLIException("Missing subsystem ID");
        }
        String subsystemID = cmdArgs[0];
        String subsystemType = cmd.getOptionValue("subsystem");
        if (subsystemType == null) {
            throw new CLIException("Missing subsystem type");
        }
        String hostname = cmd.getOptionValue("hostname");
        if (hostname == null) {
            throw new CLIException("Missing hostname");
        }
        String unsecurePort = cmd.getOptionValue("unsecure-port", "8080");
        String securePort = cmd.getOptionValue("secure-port", "8443");
        boolean domainManager = cmd.hasOption("domain-manager");
        boolean clone = cmd.hasOption("clone");
        String instanceDir = CMS.getInstanceDir();
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String subsystem = this.parent.getParent().getParent().getName();
        String subsystemDir = instanceDir + File.separator + subsystem;
        String subsystemConfDir = subsystemDir + File.separator + "conf";
        String configFile = subsystemConfDir + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        EngineConfig cs = new EngineConfig(storage);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LDAPAuthenticationConfig authConfig = ldapConfig.getAuthenticationConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = new LdapAuthInfo();
        authInfo.setPasswordStore(passwordStore);
        authInfo.init(authConfig, connInfo.getHost(), connInfo.getPort(), connInfo.getSecure());
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            String sdDN = "ou=Security Domain," + ldapConfig.getBaseDN();
            String cn = hostname + ":" + securePort;
            String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)cn) + ",cn=" + subsystemType + "List," + sdDN;
            logger.info("Adding " + dn);
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            attrs.add(new LDAPAttribute("objectclass", new String[]{"top", "pkiSubsystem"}));
            attrs.add(new LDAPAttribute("cn", cn));
            attrs.add(new LDAPAttribute("SubsystemName", subsystemID));
            attrs.add(new LDAPAttribute("Host", hostname));
            attrs.add(new LDAPAttribute("UnSecurePort", unsecurePort));
            attrs.add(new LDAPAttribute("SecurePort", securePort));
            attrs.add(new LDAPAttribute("SecureAgentPort", securePort));
            attrs.add(new LDAPAttribute("SecureAdminPort", securePort));
            attrs.add(new LDAPAttribute("SecureEEClientAuthPort", securePort));
            attrs.add(new LDAPAttribute("DomainManager", domainManager ? "TRUE" : "FALSE"));
            attrs.add(new LDAPAttribute("Clone", clone ? "TRUE" : "FALSE"));
            Enumeration e = attrs.getAttributes();
            while (e.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                for (String value : attr.getStringValueArray()) {
                    logger.debug("- " + attr.getName() + ": " + value);
                }
            }
            LDAPEntry entry = new LDAPEntry(dn, attrs);
            conn.add(entry);
        }
        finally {
            conn.disconnect();
        }
    }
}

