/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.SelfTestCollection;
import com.netscape.certsrv.selftests.SelfTestData;
import com.netscape.certsrv.selftests.SelfTestResource;
import com.netscape.certsrv.selftests.SelfTestResult;
import com.netscape.certsrv.selftests.SelfTestResults;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestService
extends PKIService
implements SelfTestResource {
    public static Logger logger = LoggerFactory.getLogger(SelfTestService.class);

    public SelfTestService() {
        logger.debug("SelfTestService.<init>()");
    }

    public SelfTestData createSelfTestData(SelfTestSubsystem subsystem, String selfTestID) throws UnsupportedEncodingException, EMissingSelfTestException {
        SelfTestData selfTestData = new SelfTestData();
        selfTestData.setID(selfTestID);
        selfTestData.setEnabledAtStartup(Boolean.valueOf(subsystem.isSelfTestEnabledAtStartup(selfTestID)));
        try {
            selfTestData.setCriticalAtStartup(Boolean.valueOf(subsystem.isSelfTestCriticalAtStartup(selfTestID)));
        }
        catch (EMissingSelfTestException eMissingSelfTestException) {
            // empty catch block
        }
        selfTestData.setEnabledOnDemand(Boolean.valueOf(subsystem.isSelfTestEnabledOnDemand(selfTestID)));
        try {
            selfTestData.setCriticalOnDemand(Boolean.valueOf(subsystem.isSelfTestCriticalOnDemand(selfTestID)));
        }
        catch (EMissingSelfTestException eMissingSelfTestException) {
            // empty catch block
        }
        selfTestID = URLEncoder.encode(selfTestID, "UTF-8");
        return selfTestData;
    }

    public Response findSelfTests(String filter, Integer start, Integer size) {
        logger.info("SelfTestService: Searching for selftests");
        logger.info("SelfTestService: - filter: " + filter);
        logger.info("SelfTestService: - start: " + start);
        logger.info("SelfTestService: - size: " + size);
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter too short: " + filter);
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        CMSEngine engine = this.getCMSEngine();
        SelfTestSubsystem subsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
        try {
            int i;
            logger.info("SelfTestService: Results:");
            ArrayList<String> results = new ArrayList<String>();
            for (String name : subsystem.getSelfTestNames()) {
                if (filter != null && !name.contains(filter)) continue;
                logger.info("SelfTestService: - " + name);
                results.add(name);
            }
            SelfTestCollection response = new SelfTestCollection();
            Iterator entries = results.iterator();
            for (i = 0; i < start && entries.hasNext(); ++i) {
                entries.next();
            }
            while (i < start + size && entries.hasNext()) {
                SelfTestData data = this.createSelfTestData(subsystem, (String)entries.next());
                response.addEntry((Object)data);
                ++i;
            }
            while (entries.hasNext()) {
                entries.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (Exception e) {
            logger.error("SelfTestService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage());
        }
    }

    public Response getSelfTest(String selfTestID) {
        logger.info("SelfTestService: Retrieving selftest " + selfTestID);
        if (selfTestID == null) {
            throw new BadRequestException("Missing selftest ID");
        }
        CMSEngine engine = this.getCMSEngine();
        SelfTestSubsystem subsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
        try {
            return this.createOKResponse(this.createSelfTestData(subsystem, selfTestID));
        }
        catch (Exception e) {
            logger.error("SelfTestService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage());
        }
    }

    public Response executeSelfTests(String action) {
        logger.info("SelfTestService: Executing selftest " + action);
        if (action == null) {
            throw new BadRequestException("Missing selftest action");
        }
        if (!"run".equals(action)) {
            throw new BadRequestException("Invalid action: " + action);
        }
        CMSEngine engine = this.getCMSEngine();
        SelfTestSubsystem subsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
        try {
            subsystem.runSelfTestsOnDemand();
        }
        catch (Exception e) {
            logger.error("SelfTestService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage());
        }
        return this.createNoContentResponse();
    }

    public Response runSelfTests() {
        logger.info("SelfTestService: Running all selftests");
        SelfTestResults results = new SelfTestResults();
        CMSEngine engine = this.getCMSEngine();
        SelfTestSubsystem subsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
        try {
            for (String selfTestID : subsystem.listSelfTestsEnabledOnDemand()) {
                Response response = this.runSelfTest(selfTestID);
                SelfTestResult result = (SelfTestResult)response.getEntity();
                results.addEntry((Object)result);
            }
        }
        catch (Exception e) {
            logger.error("SelfTestService: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage());
        }
        return this.createOKResponse(results);
    }

    public Response runSelfTest(String selfTestID) {
        logger.info("SelfTestService: Running selftest " + selfTestID);
        SelfTestResult result = new SelfTestResult();
        result.setID(selfTestID);
        CMSEngine engine = this.getCMSEngine();
        SelfTestSubsystem subsystem = (SelfTestSubsystem)engine.getSubsystem("selftests");
        try {
            subsystem.runSelfTest(selfTestID);
            result.setStatus("PASSED");
        }
        catch (Exception e) {
            logger.error("SelfTestService: " + e.getMessage(), (Throwable)e);
            result.setStatus("FAILED");
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.printStackTrace(out);
            result.setOutput(sw.toString());
        }
        logger.info("SelfTestService: Status: " + result.getStatus());
        return this.createOKResponse(result);
    }
}

