/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.tools.launchers.SystemMemoryInfo;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public final class MachineDependentHeap {
    private static final long GB = 0x40000000L;
    private static final long MAX_HEAP_SIZE = 0x7C0000000L;
    private static final long MAX_ML_HEAP_SIZE = 0x80000000L;
    private static final long MIN_HEAP_SIZE = 0x8000000L;
    private static final int DEFAULT_HEAP_SIZE_MB = 1024;
    private static final String ELASTICSEARCH_YML = "elasticsearch.yml";
    private static final String[] USER_DEFINED_HEAP_ARGS = new String[]{"-Xmx", "-Xms", "-XX:MaxHeapSize", "-XX:MinHeapSize", "-XX:InitialHeapSize"};
    private final SystemMemoryInfo systemMemoryInfo;

    public MachineDependentHeap(SystemMemoryInfo systemMemoryInfo) {
        this.systemMemoryInfo = systemMemoryInfo;
    }

    public List<String> determineHeapSettings(Path configDir, List<String> userDefinedJvmOptions) throws IOException {
        if (this.isHeapExplicitlyConfigured(userDefinedJvmOptions)) {
            return Collections.emptyList();
        }
        Path config = configDir.resolve(ELASTICSEARCH_YML);
        try (InputStream in = Files.newInputStream(config, new OpenOption[0]);){
            List<String> list = this.determineHeapSettings(in);
            return list;
        }
    }

    List<String> determineHeapSettings(InputStream config) {
        MachineNodeRole nodeRole = NodeRoleParser.parse(config);
        try {
            long availableSystemMemory = this.systemMemoryInfo.availableSystemMemory();
            return MachineDependentHeap.options(nodeRole.heap(availableSystemMemory));
        }
        catch (SystemMemoryInfo.SystemMemoryInfoException e) {
            return MachineDependentHeap.options(1024);
        }
    }

    private boolean isHeapExplicitlyConfigured(List<String> userDefinedJvmOptions) {
        return userDefinedJvmOptions.stream().anyMatch(option -> Arrays.stream(USER_DEFINED_HEAP_ARGS).anyMatch(option::startsWith));
    }

    private static List<String> options(int heapSize) {
        return Arrays.asList("-Xms" + heapSize + "m", "-Xmx" + heapSize + "m");
    }

    static class NodeRoleParser {
        private static final Set<String> LEGACY_ROLE_SETTINGS = new HashSet<String>(Arrays.asList("node.master", "node.ingest", "node.data", "node.voting_only", "node.ml", "node.transform", "node.remote_cluster_client"));

        NodeRoleParser() {
        }

        public static MachineNodeRole parse(InputStream config) {
            Map root;
            Yaml yaml = new Yaml();
            try {
                root = (Map)yaml.load(config);
            }
            catch (ClassCastException | YAMLException ex) {
                return MachineNodeRole.UNKNOWN;
            }
            if (root != null) {
                Map<String, Object> map = NodeRoleParser.flatten(root, null);
                if (NodeRoleParser.hasLegacySettings(map.keySet())) {
                    return MachineNodeRole.UNKNOWN;
                }
                List roles = null;
                try {
                    if (map.containsKey("node.roles")) {
                        roles = (List)map.get("node.roles");
                    }
                }
                catch (ClassCastException ex) {
                    return MachineNodeRole.UNKNOWN;
                }
                if (roles == null || roles.isEmpty()) {
                    return MachineNodeRole.DATA;
                }
                if (NodeRoleParser.containsOnly(roles, "master")) {
                    return MachineNodeRole.MASTER_ONLY;
                }
                if (roles.contains("ml") && NodeRoleParser.containsOnly(roles, "ml", "remote_cluster_client")) {
                    return MachineNodeRole.ML_ONLY;
                }
                return MachineNodeRole.DATA;
            }
            return MachineNodeRole.DATA;
        }

        private static Map<String, Object> flatten(Map<String, Object> config, String parentPath) {
            HashMap<String, Object> flatMap = new HashMap<String, Object>();
            String prefix = parentPath != null ? parentPath + "." : "";
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    flatMap.putAll(NodeRoleParser.flatten((Map)entry.getValue(), prefix + entry.getKey()));
                    continue;
                }
                flatMap.put(prefix + entry.getKey(), entry.getValue());
            }
            return flatMap;
        }

        private static <T> boolean containsOnly(Collection<T> collection, T ... items) {
            return Arrays.asList(items).containsAll(collection);
        }

        private static boolean hasLegacySettings(Set<String> keys) {
            return LEGACY_ROLE_SETTINGS.stream().anyMatch(keys::contains);
        }
    }

    static enum MachineNodeRole {
        MASTER_ONLY(m -> MachineNodeRole.mb(Math.min((long)((double)m.longValue() * 0.6), 0x7C0000000L))),
        ML_ONLY(m -> MachineNodeRole.mb(m < 0x80000000L ? (long)((double)m.longValue() * 0.4) : (long)Math.min((double)m.longValue() * 0.25, 2.147483648E9))),
        DATA(m -> MachineNodeRole.mb(m < 0x40000000L ? Math.max((long)((double)m.longValue() * 0.4), 0x8000000L) : Math.min((long)((double)m.longValue() * 0.5), 0x7C0000000L))),
        UNKNOWN(m -> 1024);

        private final Function<Long, Integer> formula;

        private MachineNodeRole(Function<Long, Integer> formula) {
            this.formula = formula;
        }

        public int heap(long systemMemory) {
            return this.formula.apply(systemMemory);
        }

        private static int mb(long bytes) {
            return (int)(bytes / 0x100000L);
        }
    }
}

