/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public abstract class ListTreeImpl<T extends Tree>
extends JavaTree
implements ListTree<T> {
    private final List<T> list;
    private final List<SyntaxToken> separators;

    protected ListTreeImpl(List<T> list) {
        this.list = list;
        this.separators = new ArrayList<SyntaxToken>();
    }

    protected ListTreeImpl(List<T> list, List<SyntaxToken> separators) {
        this.list = list;
        this.separators = separators;
    }

    @Override
    public List<SyntaxToken> separators() {
        return this.separators;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        for (Tree t : this.list) {
            t.accept(visitor);
        }
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.LIST;
    }

    @Override
    public List<Tree> children() {
        return ListUtils.alternate(this.list, this.separators);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return (T)((Tree)this.list.get(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((Tree)this.list.set(index, element));
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((Tree)this.list.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

