/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1610")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String IMMUTABLE_ANNOTATION = "org.immutables.value.Value$Immutable";
    private int javaVersionAsInt;

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.javaVersionAsInt = context.getJavaVersion().asInt();
        super.setContext(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() == null && AbstractClassNoFieldShouldBeInterfaceCheck.classIsAbstract(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoFieldAndProtectedMethod(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoImmutableAnnotation(classTree) && this.supportPrivateMethod(classTree)) {
            IdentifierTree simpleName = classTree.simpleName();
            this.reportIssue(simpleName, "Convert the abstract class \"" + simpleName.name() + "\" into an interface." + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean classIsAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier(tree.modifiers(), Modifier.ABSTRACT);
    }

    private boolean supportPrivateMethod(ClassTree tree) {
        return !AbstractClassNoFieldShouldBeInterfaceCheck.hasPrivateMethod(tree) || this.javaVersionAsInt >= 9;
    }

    private static boolean hasPrivateMethod(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(Tree.Kind.METHOD)).anyMatch(member -> ModifiersUtils.hasModifier(((MethodTree)member).modifiers(), Modifier.PRIVATE));
    }

    private static boolean classHasNoFieldAndProtectedMethod(ClassTree tree) {
        return tree.members().stream().noneMatch(member -> member.is(Tree.Kind.VARIABLE) || member.is(Tree.Kind.METHOD) && AbstractClassNoFieldShouldBeInterfaceCheck.isProtectedOrOverriding((MethodTree)member));
    }

    private static boolean isProtectedOrOverriding(MethodTree member) {
        return ModifiersUtils.hasModifier(member.modifiers(), Modifier.PROTECTED) || !Boolean.FALSE.equals(member.isOverriding());
    }

    private static boolean classHasNoImmutableAnnotation(ClassTree tree) {
        SymbolMetadata classMetadata = tree.symbol().metadata();
        return !classMetadata.isAnnotatedWith(IMMUTABLE_ANNOTATION);
    }
}

