/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S3012")
public class ArrayCopyLoopCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers COLLECTION_ADD = MethodMatchers.create().ofSubTypes("java.util.Collection").names("add").addParametersMatcher("*").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.WHILE_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        StatementTree statement = tree.is(Tree.Kind.FOR_STATEMENT) ? ArrayCopyLoopCheck.checkFor((ForStatementTree)tree) : (tree.is(Tree.Kind.WHILE_STATEMENT) ? ArrayCopyLoopCheck.checkWhile((WhileStatementTree)tree) : ArrayCopyLoopCheck.checkForEach((ForEachStatement)tree));
        if (statement != null) {
            this.reportIssue(statement, "Use \"Arrays.copyOf\", \"Arrays.asList\", \"Collections.addAll\" or \"System.arraycopy\" instead.");
        }
    }

    @CheckForNull
    private static StatementTree checkFor(ForStatementTree tree) {
        StatementTree statement;
        ExpressionTree condition;
        StatementTree update;
        Symbol counter;
        ListTree<StatementTree> updates = tree.update();
        if (updates.size() == 1 && (counter = ArrayCopyLoopCheck.checkUpdate(update = (StatementTree)updates.get(0))) != null && (condition = tree.condition()) != null && ArrayCopyLoopCheck.checkCondition(condition, counter) && (statement = ArrayCopyLoopCheck.getStatement(tree)) != null && ArrayCopyLoopCheck.checkStatement(statement, counter)) {
            return statement;
        }
        return null;
    }

    @CheckForNull
    private static StatementTree checkWhile(WhileStatementTree tree) {
        StatementTree statement;
        ExpressionTree condition;
        StatementTree update;
        Symbol counter;
        BlockTree block;
        List<StatementTree> body;
        if (tree.statement().is(Tree.Kind.BLOCK) && (body = (block = (BlockTree)tree.statement()).body()).size() == 2 && (counter = ArrayCopyLoopCheck.checkUpdate(update = body.get(1))) != null && ArrayCopyLoopCheck.checkCondition(condition = tree.condition(), counter) && ArrayCopyLoopCheck.checkStatement(statement = body.get(0), counter)) {
            return statement;
        }
        return null;
    }

    @CheckForNull
    private static StatementTree checkForEach(ForEachStatement tree) {
        StatementTree statement;
        ExpressionTree expression = tree.expression();
        if (expression.symbolType().isArray() && (statement = ArrayCopyLoopCheck.getStatement(tree)) != null && statement.is(Tree.Kind.EXPRESSION_STATEMENT) && ArrayCopyLoopCheck.isArrayToListCopy(expression = ((ExpressionStatementTree)statement).expression(), tree.variable())) {
            return statement;
        }
        return null;
    }

    private static boolean checkCondition(ExpressionTree tree, Symbol counter) {
        if (tree.is(Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO)) {
            BinaryExpressionTree comparison = (BinaryExpressionTree)tree;
            ExpressionTree lhs = comparison.leftOperand();
            ExpressionTree rhs = comparison.rightOperand();
            return ArrayCopyLoopCheck.isCounter(lhs, counter) ^ ArrayCopyLoopCheck.isCounter(rhs, counter);
        }
        return false;
    }

    @CheckForNull
    private static Symbol checkUpdate(StatementTree tree) {
        ExpressionStatementTree update;
        Symbol counter = null;
        if (tree.is(Tree.Kind.EXPRESSION_STATEMENT) && (counter = ArrayCopyLoopCheck.isIncrement(update = (ExpressionStatementTree)tree)) == null && (counter = ArrayCopyLoopCheck.isPlusAssignment(update)) == null) {
            counter = ArrayCopyLoopCheck.isAssignment(update);
        }
        return counter;
    }

    private static boolean checkStatement(StatementTree tree, Symbol counter) {
        if (tree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            ExpressionTree expression = ((ExpressionStatementTree)tree).expression();
            return ArrayCopyLoopCheck.isArrayToArrayCopy(expression, counter) || ArrayCopyLoopCheck.isArrayToListCopy(expression, counter);
        }
        return false;
    }

    @CheckForNull
    private static Symbol isIncrement(ExpressionStatementTree update) {
        if (update.expression().is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT)) {
            UnaryExpressionTree increment = (UnaryExpressionTree)update.expression();
            if (increment.expression().is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)increment.expression();
                return identifier.symbol();
            }
        }
        return null;
    }

    @CheckForNull
    private static Symbol isPlusAssignment(ExpressionStatementTree update) {
        if (update.expression().is(Tree.Kind.PLUS_ASSIGNMENT)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)update.expression();
            ExpressionTree lhs = assignment.variable();
            ExpressionTree rhs = assignment.expression();
            if (lhs.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)lhs;
                if (ArrayCopyLoopCheck.isOne(rhs)) {
                    return identifier.symbol();
                }
            }
        }
        return null;
    }

    @CheckForNull
    private static Symbol isAssignment(ExpressionStatementTree update) {
        if (update.expression().is(Tree.Kind.ASSIGNMENT)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)update.expression();
            ExpressionTree lhs = assignment.variable();
            ExpressionTree rhs = assignment.expression();
            if (lhs.is(Tree.Kind.IDENTIFIER) && ArrayCopyLoopCheck.isIntegerType(lhs)) {
                Symbol counter = ((IdentifierTree)lhs).symbol();
                if (rhs.is(Tree.Kind.PLUS)) {
                    BinaryExpressionTree addition = (BinaryExpressionTree)rhs;
                    lhs = addition.leftOperand();
                    rhs = addition.rightOperand();
                    if (ArrayCopyLoopCheck.isCounter(lhs, counter) && ArrayCopyLoopCheck.isOne(rhs) || ArrayCopyLoopCheck.isOne(lhs) && ArrayCopyLoopCheck.isCounter(rhs, counter)) {
                        return counter;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isArrayToArrayCopy(ExpressionTree expression, Symbol counter) {
        if (expression.is(Tree.Kind.ASSIGNMENT)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
            ExpressionTree lhs = assignment.variable();
            ExpressionTree rhs = assignment.expression();
            if (lhs.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION) && rhs.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
                ArrayAccessExpressionTree src = (ArrayAccessExpressionTree)rhs;
                ArrayAccessExpressionTree dst = (ArrayAccessExpressionTree)lhs;
                return ArrayCopyLoopCheck.isCounter(src.dimension().expression(), counter) && ArrayCopyLoopCheck.isCounter(dst.dimension().expression(), counter);
            }
        }
        return false;
    }

    private static boolean isArrayToListCopy(ExpressionTree expression, Symbol counter) {
        ExpressionTree argument;
        MemberSelectExpressionTree select;
        MethodInvocationTree invocation;
        if (expression.is(Tree.Kind.METHOD_INVOCATION) && COLLECTION_ADD.matches(invocation = (MethodInvocationTree)expression) && invocation.methodSelect().is(Tree.Kind.MEMBER_SELECT) && (select = (MemberSelectExpressionTree)invocation.methodSelect()).expression().is(Tree.Kind.IDENTIFIER) && (argument = (ExpressionTree)invocation.arguments().get(0)).is(Tree.Kind.ARRAY_ACCESS_EXPRESSION) && !argument.symbolType().isPrimitive()) {
            ArrayAccessExpressionTree access = (ArrayAccessExpressionTree)argument;
            return access.expression().is(Tree.Kind.IDENTIFIER) && ArrayCopyLoopCheck.isCounter(access.dimension().expression(), counter);
        }
        return false;
    }

    private static boolean isArrayToListCopy(ExpressionTree expression, VariableTree iterated) {
        MemberSelectExpressionTree select;
        MethodInvocationTree invocation;
        if (expression.is(Tree.Kind.METHOD_INVOCATION) && COLLECTION_ADD.matches(invocation = (MethodInvocationTree)expression) && (expression = invocation.methodSelect()).is(Tree.Kind.MEMBER_SELECT) && (select = (MemberSelectExpressionTree)expression).expression().is(Tree.Kind.IDENTIFIER)) {
            ExpressionTree argument = (ExpressionTree)invocation.arguments().get(0);
            Symbol identifier = ArrayCopyLoopCheck.getIdentifier(argument);
            return identifier != null && identifier.equals(iterated.symbol()) && !argument.symbolType().isPrimitive();
        }
        return false;
    }

    @CheckForNull
    private static Symbol getIdentifier(ExpressionTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)tree).symbol();
        }
        return null;
    }

    private static boolean isCounter(ExpressionTree tree, Symbol counter) {
        Symbol identifier = ArrayCopyLoopCheck.getIdentifier(tree);
        return identifier != null && identifier.equals(counter);
    }

    private static boolean isIntegerType(ExpressionTree tree) {
        return tree.symbolType().isPrimitive(Type.Primitives.INT) || tree.symbolType().isPrimitive(Type.Primitives.LONG);
    }

    private static boolean isOne(ExpressionTree tree) {
        return Long.valueOf(1L).equals(LiteralUtils.longLiteralValue(tree));
    }

    @CheckForNull
    private static StatementTree getStatement(Tree tree) {
        if (tree.is(Tree.Kind.FOR_STATEMENT)) {
            ForStatementTree loop = (ForStatementTree)tree;
            return ArrayCopyLoopCheck.getBody(loop.statement(), 1);
        }
        ForEachStatement loop = (ForEachStatement)tree;
        return ArrayCopyLoopCheck.getBody(loop.statement(), 1);
    }

    @CheckForNull
    private static StatementTree getBody(StatementTree tree, int expectedSize) {
        if (tree.is(Tree.Kind.BLOCK)) {
            BlockTree block = (BlockTree)tree;
            List<StatementTree> body = block.body();
            tree = body.size() == expectedSize ? body.get(0) : null;
        }
        return tree;
    }
}

