/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1200")
public class ClassCouplingCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="max", description="Maximum number of classes a single class is allowed to depend upon", defaultValue="20")
    public int max = 20;
    private final Deque<Set<String>> nesting = new LinkedList<Set<String>>();
    private Set<String> types;
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (tree.is(Tree.Kind.CLASS) && tree.simpleName() != null) {
            this.nesting.push(this.types);
            this.types = new HashSet<String>();
        }
        this.checkTypes(tree.superClass());
        this.checkTypes((List<? extends Tree>)tree.superInterfaces());
        super.visitClass(tree);
        if (tree.is(Tree.Kind.CLASS) && tree.simpleName() != null) {
            if (this.types.size() > this.max) {
                this.context.reportIssue(this, tree.simpleName(), "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from " + this.types.size() + " to the maximum authorized " + this.max + " or less.");
            }
            this.types = this.nesting.pop();
        }
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.checkTypes(tree.type());
        super.visitVariable(tree);
    }

    @Override
    public void visitCatch(CatchTree tree) {
        this.scan(tree.block());
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.checkTypes(tree.type());
        super.visitTypeCast(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.checkTypes(tree.returnType());
        super.visitMethod(tree);
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
        this.checkTypes((List<? extends Tree>)typeParameter.bounds());
        this.checkTypes(typeParameter.identifier());
        super.visitTypeParameter(typeParameter);
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.checkTypes((List<? extends Tree>)tree.typeAlternatives());
        super.visitUnionType(tree);
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.checkTypes(tree.type());
        this.checkTypes(tree.typeArguments());
        super.visitParameterizedType(tree);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.typeArguments() != null) {
            this.checkTypes(tree.typeArguments());
        }
        if (tree.identifier().is(Tree.Kind.PARAMETERIZED_TYPE)) {
            this.scan(tree.enclosingExpression());
            this.checkTypes(((ParameterizedTypeTree)tree.identifier()).typeArguments());
            this.scan(tree.typeArguments());
            this.scan(tree.arguments());
            this.scan(tree.classBody());
        } else {
            super.visitNewClass(tree);
        }
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        this.checkTypes(tree.bound());
        super.visitWildcard(tree);
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        this.checkTypes(tree.type());
        super.visitArrayType(tree);
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.checkTypes(tree.type());
        super.visitInstanceOf(tree);
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.checkTypes(tree.type());
        super.visitNewArray(tree);
    }

    private void checkTypes(List<? extends Tree> types) {
        for (Tree tree : types) {
            this.checkTypes(tree);
        }
    }

    private void checkTypes(@Nullable Tree type) {
        if (type == null || this.types == null) {
            return;
        }
        if (type.is(Tree.Kind.IDENTIFIER)) {
            this.types.add(((IdentifierTree)type).name());
        } else if (type.is(Tree.Kind.MEMBER_SELECT)) {
            ArrayDeque<String> fullyQualifiedNameComponents = new ArrayDeque<String>();
            ExpressionTree expr = (ExpressionTree)type;
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                fullyQualifiedNameComponents.push(mse.identifier().name());
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                fullyQualifiedNameComponents.push(((IdentifierTree)expr).name());
            }
            this.types.add(String.join((CharSequence)".", fullyQualifiedNameComponents));
        }
    }
}

