/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S2253")
public class DisallowedMethodCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className", description="Name of the class whose method is forbidden")
    private String className = "";
    @RuleProperty(key="methodName", description="Name of the forbidden method")
    private String methodName = "";
    @RuleProperty(key="argumentTypes", description="Comma-delimited list of argument types, E.G. java.lang.String, int[], int")
    private String argumentTypes = "";
    @RuleProperty(key="allOverloads", description="Set to true to flag all overloads regardless of parameter type", defaultValue="false")
    private boolean allOverloads = false;

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        if (StringUtils.isEmpty(this.methodName)) {
            return MethodMatchers.none();
        }
        MethodMatchers.TypeBuilder typeBuilder = MethodMatchers.create();
        MethodMatchers.NameBuilder nameBuilder = StringUtils.isNotEmpty(this.className) ? typeBuilder.ofTypes(this.className) : typeBuilder.ofAnyType();
        MethodMatchers.ParametersBuilder parametersBuilder = nameBuilder.names(this.methodName);
        if (this.allOverloads) {
            return parametersBuilder.withAnyParameters().build();
        }
        String[] args = StringUtils.split(this.argumentTypes, ",");
        if (args.length == 0) {
            return parametersBuilder.addWithoutParametersMatcher().build();
        }
        String[] trimmedArgs = new String[args.length];
        for (int i = 0; i < trimmedArgs.length; ++i) {
            trimmedArgs[i] = StringUtils.trim(args[i]);
        }
        return parametersBuilder.addParametersMatcher(trimmedArgs).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), "Remove this forbidden call");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public void setAllOverloads(boolean allOverloads) {
        this.allOverloads = allOverloads;
    }
}

