/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1862")
public class DuplicateConditionIfElseIfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        StatementTree statement = tree.elseStatement();
        while (statement != null && statement.is(Tree.Kind.IF_STATEMENT)) {
            IfStatementTree ifStatement = (IfStatementTree)statement;
            if (SyntacticEquivalence.areEquivalent(condition, ifStatement.condition())) {
                this.context.reportIssue(this, ifStatement.condition(), "This branch can not be reached because the condition duplicates a previous condition in the same sequence of \"if/else if\" statements", Collections.singletonList(new JavaFileScannerContext.Location("Original", condition)), null);
            }
            statement = ifStatement.elseStatement();
        }
        super.visitIfStatement(tree);
    }
}

