/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1640")
public class EnumMapCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final MethodMatchers mapPut = MethodMatchers.create().ofTypes("java.util.Map").names("put").withAnyParameters().build();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        if (tree.type().symbolType().isSubtypeOf(JAVA_UTIL_MAP)) {
            ExpressionTree initializer = tree.initializer();
            if (initializer != null && !EnumMapCheck.usesNullKey(tree.symbol())) {
                this.checkNewMap(initializer, EnumMapCheck.hasEnumKey(tree.type().symbolType()));
            }
        } else {
            super.visitVariable(tree);
        }
    }

    private static boolean usesNullKey(Symbol symbol) {
        List<IdentifierTree> usages = symbol.usages();
        for (IdentifierTree usage : usages) {
            if (!MethodTreeUtils.consecutiveMethodInvocation(usage).filter(mit -> mapPut.matches((MethodInvocationTree)mit) && ((ExpressionTree)mit.arguments().get(0)).is(Tree.Kind.NULL_LITERAL)).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().symbolType().isSubtypeOf(JAVA_UTIL_MAP)) {
            this.checkNewMap(tree.expression(), EnumMapCheck.hasEnumKey(tree.variable().symbolType()));
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (EnumMapCheck.isUnorderedMap(tree.symbolType()) && EnumMapCheck.hasEnumKey(tree.identifier().symbolType())) {
            this.addIssue(tree);
        } else {
            super.visitNewClass(tree);
        }
    }

    private void checkNewMap(ExpressionTree given, boolean useEnumKey) {
        NewClassTree newClassTree;
        ExpressionTree expression = ExpressionUtils.skipParentheses(given);
        if (expression.is(Tree.Kind.NEW_CLASS) && EnumMapCheck.isUnorderedMap((newClassTree = (NewClassTree)expression).symbolType()) && (useEnumKey || EnumMapCheck.hasEnumKey(newClassTree.identifier().symbolType()))) {
            this.addIssue(newClassTree);
        }
    }

    private static boolean isUnorderedMap(Type type) {
        return type.isSubtypeOf("java.util.HashMap") && !type.isSubtypeOf("java.util.LinkedHashMap");
    }

    private static boolean hasEnumKey(Type type) {
        return type.isParameterized() && type.typeArguments().get(0).symbol().isEnum();
    }

    private void addIssue(Tree typeTree) {
        this.context.reportIssue(this, typeTree, "Convert this Map to an EnumMap.");
    }
}

