/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1215")
public class GarbageCollectorCalledCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers GC_METHOD_MATCHER = MethodMatchers.create().ofTypes("java.lang.Runtime", "java.lang.System").names("gc", "runFinalization").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (GC_METHOD_MATCHER.matches(mit)) {
            this.reportIssue(ExpressionUtils.methodName(mit), "Don't try to be smarter than the JVM, remove this call to run the garbage collector.");
        }
    }
}

