/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2639")
public class InappropriateRegexpCheck
extends AbstractMethodDetection {
    private static final String INAPPROPRIATE_REGEXPS = "[.|]";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.lang.String").names("replaceAll", "replaceFirst").withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        if (InappropriateRegexpCheck.isInappropriateRegexpStringLiteral(firstArg) || InappropriateRegexpCheck.isFileSeparator(firstArg)) {
            this.reportIssue(firstArg, "Correct this regular expression.");
        }
    }

    private static boolean isInappropriateRegexpStringLiteral(ExpressionTree firstArg) {
        return firstArg.asConstant(String.class).filter(regexp -> regexp.matches(INAPPROPRIATE_REGEXPS)).isPresent();
    }

    private static boolean isFileSeparator(ExpressionTree firstArg) {
        if (firstArg.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)firstArg;
            return "separator".equals(mse.identifier().name()) && mse.expression().symbolType().is("java.io.File");
        }
        return false;
    }
}

