/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1602")
public class LambdaSingleExpressionCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
        Tree lambdaBody = lambdaExpressionTree.body();
        if (LambdaSingleExpressionCheck.isBlockWithOneStatement(lambdaBody)) {
            String message = "Remove useless curly braces around statement";
            if (LambdaSingleExpressionCheck.singleStatementIsReturn(lambdaExpressionTree)) {
                message = message + " and then remove useless return keyword";
            }
            this.reportIssue(((BlockTree)lambdaBody).openBraceToken(), message + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        boolean result = false;
        if (tree.is(Tree.Kind.BLOCK)) {
            List<StatementTree> blockBody = ((BlockTree)tree).body();
            result = blockBody.size() == 1 && LambdaSingleExpressionCheck.isRefactorizable(blockBody.get(0));
        }
        return result;
    }

    private static boolean isRefactorizable(StatementTree statementTree) {
        return LambdaSingleExpressionCheck.isBlockWithOneStatement(statementTree) || statementTree.is(Tree.Kind.EXPRESSION_STATEMENT) || LambdaSingleExpressionCheck.isReturnStatement(statementTree);
    }

    private static boolean singleStatementIsReturn(LambdaExpressionTree lambdaExpressionTree) {
        return LambdaSingleExpressionCheck.isReturnStatement(((BlockTree)lambdaExpressionTree.body()).body().get(0));
    }

    private static boolean isReturnStatement(Tree tree) {
        return tree.is(Tree.Kind.RETURN_STATEMENT);
    }
}

