/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00113", repositoryKey="squid")
@Rule(key="S113")
public class MissingNewLineAtEndOfFileCheck
implements JavaFileScanner {
    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (MissingNewLineAtEndOfFileCheck.isEmptyOrNotEndingWithNewLine(context.getFileContent())) {
            context.addIssueOnFile(this, "Add a new line at the end of this file.");
        }
    }

    private static boolean isEmptyOrNotEndingWithNewLine(String content) {
        if (content.isEmpty()) {
            return true;
        }
        char lastChar = content.charAt(content.length() - 1);
        return lastChar != '\n' && lastChar != '\r';
    }
}

