/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ModifiersOrderCheck", repositoryKey="squid")
@Rule(key="S1124")
public class ModifiersOrderCheck
extends IssuableSubscriptionVisitor {
    private Set<Tree> alreadyReported = new HashSet<Tree>();

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.alreadyReported.clear();
        super.setContext(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MODIFIERS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.alreadyReported.contains(tree)) {
            this.alreadyReported.add(tree);
            ModifierTree badlyOrderedModifier = ModifiersOrderCheck.getFirstBadlyOrdered((ModifiersTree)tree);
            if (badlyOrderedModifier != null) {
                this.reportIssue(badlyOrderedModifier, "Reorder the modifiers to comply with the Java Language Specification.");
            }
        }
    }

    private static ModifierTree getFirstBadlyOrdered(ModifiersTree modifiersTree) {
        ModifierTree modifier;
        ListIterator<ModifierTree> modifiersIterator = modifiersTree.listIterator();
        ModifiersOrderCheck.skipAnnotations(modifiersIterator);
        Modifier[] modifiers = Modifier.values();
        int modifierIndex = 0;
        while (modifiersIterator.hasNext() && !(modifier = modifiersIterator.next()).is(Tree.Kind.ANNOTATION)) {
            ModifierKeywordTree mkt = (ModifierKeywordTree)modifier;
            while (modifierIndex < modifiers.length && !mkt.modifier().equals((Object)modifiers[modifierIndex])) {
                ++modifierIndex;
            }
            if (modifierIndex != modifiers.length) continue;
            return modifier;
        }
        return ModifiersOrderCheck.testOnlyAnnotationsAreLeft(modifiersIterator);
    }

    private static void skipAnnotations(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext() && modifiersIterator.next().is(Tree.Kind.ANNOTATION)) {
        }
        if (modifiersIterator.hasNext()) {
            modifiersIterator.previous();
        }
    }

    private static ModifierTree testOnlyAnnotationsAreLeft(ListIterator<ModifierTree> modifiersIterator) {
        while (modifiersIterator.hasNext()) {
            ModifierTree modifier = modifiersIterator.next();
            if (modifier.is(Tree.Kind.ANNOTATION)) continue;
            modifiersIterator.previous();
            if (!modifiersIterator.hasPrevious()) continue;
            return modifiersIterator.previous();
        }
        return null;
    }
}

