/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S4201")
public class NullCheckWithInstanceofCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree rightOp;
        BinaryExpressionTree binaryExpression = (BinaryExpressionTree)tree;
        ExpressionTree leftOp = ExpressionUtils.skipParentheses(binaryExpression.leftOperand());
        if (NullCheckWithInstanceofCheck.is(Tree.Kind.EQUAL_TO, leftOp, rightOp = ExpressionUtils.skipParentheses(binaryExpression.rightOperand())) && NullCheckWithInstanceofCheck.nullCheckWithInstanceOf(leftOp, rightOp, binaryExpression.kind(), Tree.Kind.CONDITIONAL_OR) || NullCheckWithInstanceofCheck.is(Tree.Kind.NOT_EQUAL_TO, leftOp, rightOp) && NullCheckWithInstanceofCheck.nullCheckWithInstanceOf(leftOp, rightOp, binaryExpression.kind(), Tree.Kind.CONDITIONAL_AND)) {
            this.reportIssue(NullCheckWithInstanceofCheck.treeToReport(leftOp, rightOp), "Remove this unnecessary null check; \"instanceof\" returns false for nulls.");
        }
    }

    private static boolean nullCheckWithInstanceOf(ExpressionTree leftOp, ExpressionTree rightOp, Tree.Kind binaryExpressionKind, Tree.Kind expectedKind) {
        ExpressionTree binaryVariable = Optional.ofNullable(NullCheckWithInstanceofCheck.binaryExpressionVariable(leftOp)).orElse(NullCheckWithInstanceofCheck.binaryExpressionVariable(rightOp));
        if (binaryVariable == null || binaryExpressionKind != expectedKind) {
            return false;
        }
        ExpressionTree instanceofVariable = Optional.ofNullable(NullCheckWithInstanceofCheck.instanceofFound(rightOp, binaryExpressionKind)).orElse(NullCheckWithInstanceofCheck.instanceofFound(leftOp, binaryExpressionKind));
        return instanceofVariable != null && SyntacticEquivalence.areEquivalent(binaryVariable, instanceofVariable);
    }

    private static ExpressionTree treeToReport(ExpressionTree left, ExpressionTree right) {
        return left.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO) ? left : right;
    }

    @CheckForNull
    private static ExpressionTree binaryExpressionVariable(ExpressionTree expression) {
        BinaryExpressionTree binaryExpression = null;
        if (expression.is(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO)) {
            binaryExpression = (BinaryExpressionTree)expression;
            if (binaryExpression.leftOperand().is(Tree.Kind.NULL_LITERAL)) {
                return binaryExpression.rightOperand();
            }
            if (binaryExpression.rightOperand().is(Tree.Kind.NULL_LITERAL)) {
                return binaryExpression.leftOperand();
            }
        }
        return null;
    }

    @CheckForNull
    private static ExpressionTree instanceofFound(ExpressionTree expressionTree, Tree.Kind kind) {
        if (kind != Tree.Kind.CONDITIONAL_OR) {
            return NullCheckWithInstanceofCheck.instanceofLHS(expressionTree);
        }
        if (expressionTree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
            return NullCheckWithInstanceofCheck.instanceofLHS(ExpressionUtils.skipParentheses(((UnaryExpressionTree)expressionTree).expression()));
        }
        return null;
    }

    @CheckForNull
    private static ExpressionTree instanceofLHS(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.INSTANCE_OF)) {
            return ((InstanceOfTree)expressionTree).expression();
        }
        return null;
    }

    private static boolean is(Tree.Kind kind, Tree ... trees) {
        return Arrays.stream(trees).anyMatch(tree -> tree.is(kind));
    }
}

