/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1710")
public class RepeatAnnotationCheck
extends BaseTreeVisitor
implements JavaFileScanner,
JavaVersionAwareVisitor {
    private JavaFileScannerContext context;

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
        NewArrayTree arrayTree;
        if (RepeatAnnotationCheck.isArrayInitialized(annotationTree) && RepeatAnnotationCheck.isAllSameAnnotation((arrayTree = (NewArrayTree)annotationTree.arguments().get(0)).initializers()) && RepeatAnnotationCheck.isAnnotationRepeatable((ExpressionTree)arrayTree.initializers().get(0))) {
            this.context.reportIssue(this, annotationTree.annotationType(), "Remove the '" + RepeatAnnotationCheck.getAnnotationName(annotationTree) + "' wrapper from this annotation group" + this.context.getJavaVersion().java8CompatibilityMessage());
        }
        super.visitAnnotation(annotationTree);
    }

    private static boolean isAnnotationRepeatable(ExpressionTree expressionTree) {
        return expressionTree.symbolType().symbol().metadata().isAnnotatedWith("java.lang.annotation.Repeatable");
    }

    private static boolean isAllSameAnnotation(List<ExpressionTree> initializers) {
        if (initializers.isEmpty()) {
            return false;
        }
        String annotationName = RepeatAnnotationCheck.getAnnotationName(initializers.get(0));
        if (annotationName.isEmpty()) {
            return false;
        }
        for (int i = 1; i < initializers.size(); ++i) {
            if (annotationName.equals(RepeatAnnotationCheck.getAnnotationName(initializers.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static String getAnnotationName(ExpressionTree initializer) {
        String result = "";
        if (initializer.is(Tree.Kind.ANNOTATION)) {
            TypeTree annotationType = ((AnnotationTree)initializer).annotationType();
            if (annotationType.is(Tree.Kind.IDENTIFIER)) {
                result = ((IdentifierTree)annotationType).name();
            } else if (annotationType.is(Tree.Kind.MEMBER_SELECT)) {
                result = RepeatAnnotationCheck.fullName((MemberSelectExpressionTree)annotationType);
            }
        }
        return result;
    }

    private static String fullName(MemberSelectExpressionTree tree) {
        if (tree.expression().is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)tree.expression()).name() + "." + tree.identifier().name();
        }
        return RepeatAnnotationCheck.fullName((MemberSelectExpressionTree)tree.expression()) + "." + tree.identifier().name();
    }

    private static boolean isArrayInitialized(AnnotationTree annotationTree) {
        return annotationTree.arguments().size() == 1 && ((ExpressionTree)annotationTree.arguments().get(0)).is(Tree.Kind.NEW_ARRAY);
    }
}

