/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1126")
public class ReturnOfBooleanExpressionsCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        StatementTree elseStatementOrNextStatement = ReturnOfBooleanExpressionsCheck.getStatementTree(ifStatementTree);
        StatementTree thenStatement = ifStatementTree.thenStatement();
        if (ReturnOfBooleanExpressionsCheck.hasOneReturnBoolean(elseStatementOrNextStatement) && ReturnOfBooleanExpressionsCheck.hasOneReturnBoolean(thenStatement)) {
            this.reportIssue(ifStatementTree.ifKeyword(), "Replace this if-then-else statement by a single return statement.");
        } else {
            Optional<MethodInvocationTree> elseMIT = ReturnOfBooleanExpressionsCheck.getMethodInvocation(elseStatementOrNextStatement);
            Optional<MethodInvocationTree> thenMIT = ReturnOfBooleanExpressionsCheck.getMethodInvocation(thenStatement);
            if (elseMIT.isPresent() && thenMIT.isPresent() && ReturnOfBooleanExpressionsCheck.areAllSyntacticallyEquivalentExceptBoolean(elseMIT.get(), thenMIT.get())) {
                this.reportIssue(ifStatementTree.ifKeyword(), "Replace this if-then-else statement by a single method invocation.");
            }
        }
    }

    private static StatementTree getStatementTree(IfStatementTree ifStatementTree) {
        Tree next;
        JavaTree parent;
        List<Tree> children;
        int indexOfIf;
        StatementTree elseStatementOrNextStatement = ifStatementTree.elseStatement();
        if (elseStatementOrNextStatement == null && (indexOfIf = (children = (parent = (JavaTree)ifStatementTree.parent()).getChildren()).indexOf(ifStatementTree)) < children.size() - 1 && !(next = children.get(indexOfIf + 1)).is(Tree.Kind.TOKEN)) {
            elseStatementOrNextStatement = (StatementTree)next;
        }
        return elseStatementOrNextStatement;
    }

    private static boolean hasOneReturnBoolean(@Nullable StatementTree statementTree) {
        if (statementTree == null) {
            return false;
        }
        if (statementTree.is(Tree.Kind.BLOCK)) {
            BlockTree block = (BlockTree)statementTree;
            return block.body().size() == 1 && ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral(block.body().get(0));
        }
        return ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral(statementTree);
    }

    private static boolean isReturnBooleanLiteral(StatementTree statementTree) {
        if (statementTree.is(Tree.Kind.RETURN_STATEMENT)) {
            ExpressionTree expression = ((ReturnStatementTree)statementTree).expression();
            return expression != null && expression.is(Tree.Kind.BOOLEAN_LITERAL);
        }
        return false;
    }

    private static Optional<MethodInvocationTree> getMethodInvocation(@Nullable StatementTree statementTree) {
        if (statementTree == null) {
            return Optional.empty();
        }
        Tree newTree = statementTree;
        if (newTree.is(Tree.Kind.BLOCK)) {
            List<StatementTree> body = ((BlockTree)newTree).body();
            if (body.size() != 1) {
                return Optional.empty();
            }
            newTree = body.get(0);
        }
        ExpressionTree expressionTree = null;
        if (newTree.is(Tree.Kind.RETURN_STATEMENT)) {
            expressionTree = ((ReturnStatementTree)newTree).expression();
        } else if (newTree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            expressionTree = ((ExpressionStatementTree)newTree).expression();
        }
        if (expressionTree != null) {
            expressionTree = ExpressionUtils.skipParentheses(expressionTree);
            if (expressionTree.is(Tree.Kind.METHOD_INVOCATION)) {
                return Optional.of((MethodInvocationTree)expressionTree);
            }
        }
        return Optional.empty();
    }

    private static Tree firstNonParenthesesParent(Tree tree) {
        Tree skip = tree.parent();
        while (skip.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            skip = skip.parent();
        }
        return skip;
    }

    private static boolean areAllSyntacticallyEquivalentExceptBoolean(MethodInvocationTree mit1, MethodInvocationTree mit2) {
        if (ReturnOfBooleanExpressionsCheck.firstNonParenthesesParent(mit1).kind() != ReturnOfBooleanExpressionsCheck.firstNonParenthesesParent(mit2).kind()) {
            return false;
        }
        if (!SyntacticEquivalence.areEquivalent(mit1.methodSelect(), mit2.methodSelect())) {
            return false;
        }
        Arguments mit1Args = mit1.arguments();
        Arguments mit2Args = mit2.arguments();
        if (mit1Args.size() != mit2Args.size()) {
            return false;
        }
        boolean containsBooleanLiteral = false;
        for (int i = 0; i < mit1Args.size(); ++i) {
            ExpressionTree arg1 = ExpressionUtils.skipParentheses((ExpressionTree)mit1Args.get(i));
            ExpressionTree arg2 = ExpressionUtils.skipParentheses((ExpressionTree)mit2Args.get(i));
            boolean arg1IsBooleanLiteral = arg1.is(Tree.Kind.BOOLEAN_LITERAL);
            boolean arg2IsBooleanLiteral = arg2.is(Tree.Kind.BOOLEAN_LITERAL);
            if (SyntacticEquivalence.areEquivalent(arg1, arg2)) {
                containsBooleanLiteral |= arg1IsBooleanLiteral;
                continue;
            }
            if (!arg1IsBooleanLiteral || !arg2IsBooleanLiteral) {
                return false;
            }
            containsBooleanLiteral = true;
        }
        return containsBooleanLiteral;
    }
}

