/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4530")
public class Struts1EndpointCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers STRUTS_METHOD = MethodMatchers.create().ofAnyType().names("perform", "execute").addParametersMatcher("org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse").addParametersMatcher("org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.ServletRequest", "javax.servlet.ServletResponse").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        List<IdentifierTree> actionMappingUsages;
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.symbol().owner().type().isSubtypeOf("org.apache.struts.action.Action") && STRUTS_METHOD.matches(methodTree) && !(actionMappingUsages = methodTree.parameters().get(1).symbol().usages()).isEmpty()) {
            this.reportIssue(methodTree.simpleName(), "Make sure that the ActionForm is used safely here.", actionMappingUsages.stream().map(idTree -> new JavaFileScannerContext.Location("", (Tree)idTree)).collect(Collectors.toList()), null);
        }
    }
}

