/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;

@Rule(key="S1301")
public class SwitchAtLeastThreeCasesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        int count = 0;
        for (CaseGroupTree caseGroup : tree.cases()) {
            count += caseGroup.labels().size();
        }
        if (count < 3) {
            this.context.reportIssue(this, tree.switchKeyword(), "Replace this \"switch\" statement by \"if\" statements to increase readability.");
        }
        super.visitSwitchStatement(tree);
    }
}

