/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3937")
public class UnderscoreMisplacedOnNumberCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL);
    }

    @Override
    public void visitNode(Tree tree) {
        LiteralTree literalTree = (LiteralTree)tree;
        String value = literalTree.value();
        if (UnderscoreMisplacedOnNumberCheck.hasIrregularPattern(value)) {
            this.reportIssue(literalTree, "Review this number; its irregular pattern indicates an error.");
        }
    }

    private static boolean hasIrregularPattern(String literalValue) {
        List<String> groups = Arrays.asList(UnderscoreMisplacedOnNumberCheck.cleanup(literalValue).split("_"));
        if (groups.size() <= 1) {
            return false;
        }
        int firstGroupLength = groups.get(0).length();
        List lengths = groups.stream().skip(1L).map(String::length).distinct().collect(Collectors.toList());
        return lengths.size() != 1 || (Integer)lengths.get(0) < firstGroupLength;
    }

    private static String cleanup(String literalValue) {
        String result = literalValue.toLowerCase();
        if (result.startsWith("0b") || result.startsWith("0x")) {
            result = result.substring(2);
        }
        if (result.endsWith("l")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

