/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S4970")
public class UnreachableCatchCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        if (!tryStatementTree.resourceList().isEmpty()) {
            return;
        }
        new UnreachableCatchFinder(tryStatementTree).find();
    }

    private static boolean isChecked(Type type) {
        return !type.isUnknown() && !type.isSubtypeOf("java.lang.RuntimeException") && !type.isSubtypeOf("java.lang.Error") && !type.is("java.lang.Exception") && !type.is("java.lang.Throwable");
    }

    private static boolean isHiding(Type subtype, List<Type> thrownTypes) {
        return thrownTypes.stream().anyMatch(thrownType -> thrownType.isSubtypeOf(subtype));
    }

    private static boolean isUnreachable(Type baseType, Collection<Type> subtypes, List<Type> thrownTypes) {
        return !subtypes.isEmpty() && thrownTypes.stream().allMatch(thrownType -> {
            if (!UnreachableCatchCheck.relatedTypes(thrownType, baseType)) return true;
            if (!subtypes.stream().anyMatch(thrownType::isSubtypeOf)) return false;
            return true;
        });
    }

    private static boolean relatedTypes(Type type1, Type type2) {
        return type1.isSubtypeOf(type2) || type2.isSubtypeOf(type1);
    }

    private static class CatchClauseInfo {
        List<Type> types;
        CatchTree tree;

        CatchClauseInfo(List<Type> types, CatchTree tree) {
            this.types = types;
            this.tree = tree;
        }
    }

    private static class ThrownExceptionCollector
    extends BaseTreeVisitor {
        List<Type> thrownTypes = new ArrayList<Type>();
        boolean unknownVisited = false;

        private ThrownExceptionCollector() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            this.addAllThrownTypes(mit.symbol());
            super.visitMethodInvocation(mit);
        }

        @Override
        public void visitNewClass(NewClassTree tree) {
            this.addAllThrownTypes(tree.constructorSymbol());
            super.visitNewClass(tree);
        }

        @Override
        public void visitThrowStatement(ThrowStatementTree tree) {
            this.thrownTypes.add(tree.expression().symbolType());
            super.visitThrowStatement(tree);
        }

        private void addAllThrownTypes(Symbol symbol) {
            if (symbol.isMethodSymbol()) {
                List<Type> newThrownTypes = ((Symbol.MethodSymbol)symbol).thrownTypes();
                this.thrownTypes.addAll(newThrownTypes);
                this.unknownVisited = this.unknownVisited || newThrownTypes.stream().anyMatch(Type::isUnknown);
            } else if (symbol.isUnknown()) {
                this.unknownVisited = true;
            }
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }

    private class UnreachableCatchFinder {
        Map<Type, Tree> typeToTypeTree = new HashMap<Type, Tree>();
        List<CatchClauseInfo> catchClauses = new ArrayList<CatchClauseInfo>();
        Map<Type, Set<Type>> baseToSubtype = new HashMap<Type, Set<Type>>();
        TryStatementTree tryStatementTree;
        List<Type> thrownTypes;

        UnreachableCatchFinder(TryStatementTree tryStatementTree) {
            this.tryStatementTree = tryStatementTree;
        }

        void find() {
            this.getBaseTypeCaughtAfterSubtype(this.tryStatementTree.catches());
            if (this.baseToSubtype.isEmpty()) {
                return;
            }
            ThrownExceptionCollector collector = new ThrownExceptionCollector();
            this.tryStatementTree.block().accept(collector);
            if (collector.unknownVisited || collector.thrownTypes.isEmpty()) {
                return;
            }
            this.thrownTypes = collector.thrownTypes;
            for (CatchClauseInfo catchClause : this.catchClauses) {
                List hiddenTypes = catchClause.types.stream().filter(type -> UnreachableCatchCheck.isUnreachable(type, this.baseToSubtype.getOrDefault(type, Collections.emptySet()), this.thrownTypes)).collect(Collectors.toList());
                if (hiddenTypes.size() == catchClause.types.size()) {
                    this.reportWholeCatchClause(catchClause);
                    continue;
                }
                for (Type hiddenType : hiddenTypes) {
                    this.reportSingleType(hiddenType);
                }
            }
        }

        void reportWholeCatchClause(CatchClauseInfo catchClause) {
            List subtypesHiding = catchClause.types.stream().flatMap(type -> this.baseToSubtype.get(type).stream()).filter(subtype -> UnreachableCatchCheck.isHiding(subtype, this.thrownTypes)).collect(Collectors.toList());
            UnreachableCatchCheck.this.reportIssue(catchClause.tree.catchKeyword(), "Remove or refactor this catch clause because it is unreachable as hidden by previous catch blocks.", subtypesHiding.stream().map(type -> new JavaFileScannerContext.Location("Already catch the exception", this.typeToTypeTree.get(type))).collect(Collectors.toList()), null);
        }

        void reportSingleType(Type hiddenType) {
            List subtypesHiding = this.baseToSubtype.get(hiddenType).stream().filter(subtype -> UnreachableCatchCheck.isHiding(subtype, this.thrownTypes)).collect(Collectors.toList());
            UnreachableCatchCheck.this.reportIssue(this.typeToTypeTree.get(hiddenType), "Remove this type because it is unreachable as hidden by previous catch blocks.", subtypesHiding.stream().map(type -> new JavaFileScannerContext.Location("Already catch the exception", this.typeToTypeTree.get(type))).collect(Collectors.toList()), null);
        }

        void getBaseTypeCaughtAfterSubtype(List<CatchTree> catches) {
            List catchTypes = catches.stream().flatMap(c -> {
                ArrayList<Type> types = new ArrayList<Type>();
                this.collectTypesFromTypeTree(c.parameter().type(), types);
                this.catchClauses.add(new CatchClauseInfo((List<Type>)types, (CatchTree)c));
                return types.stream();
            }).filter(x$0 -> UnreachableCatchCheck.isChecked(x$0)).collect(Collectors.toList());
            for (int i = 0; i < catchTypes.size() - 1; ++i) {
                Type topType = (Type)catchTypes.get(i);
                for (int j = i + 1; j < catchTypes.size(); ++j) {
                    Type bottomType = (Type)catchTypes.get(j);
                    if (!topType.isSubtypeOf(bottomType)) continue;
                    this.baseToSubtype.computeIfAbsent(bottomType, k -> new HashSet()).add(topType);
                }
            }
        }

        void collectTypesFromTypeTree(TypeTree typeTree, List<Type> types) {
            if (typeTree.is(Tree.Kind.UNION_TYPE)) {
                ((UnionTypeTree)typeTree).typeAlternatives().forEach(t -> this.collectTypesFromTypeTree((TypeTree)t, types));
            } else {
                Type type = typeTree.symbolType();
                this.typeToTypeTree.put(type, typeTree);
                types.add(type);
            }
        }
    }
}

