/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UselessParenthesesCheck", repositoryKey="squid")
@Rule(key="S1110")
public class UselessParenthesesCheck
extends IssuableSubscriptionVisitor {
    @Override
    public void visitNode(Tree tree) {
        ParenthesizedTree parenthesizedTree = (ParenthesizedTree)tree;
        if (parenthesizedTree.expression().is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            this.reportIssue(((ParenthesizedTree)parenthesizedTree.expression()).openParenToken(), "Remove these useless parentheses.", Collections.singletonList(new JavaFileScannerContext.Location("", parenthesizedTree.closeParenToken())), null);
        }
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.PARENTHESIZED_EXPRESSION);
    }
}

