/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5803")
public class VisibleForTestingUsageCheck
extends IssuableSubscriptionVisitor {
    private final Set<Symbol> reportedSymbols = new HashSet<Symbol>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitNode(Tree tree) {
        IdentifierTree identifier = (IdentifierTree)tree;
        Symbol symbol = identifier.symbol();
        if (symbol.isUnknown() || symbol.metadata().annotations().isEmpty() || this.reportedSymbols.contains(symbol)) {
            return;
        }
        if (VisibleForTestingUsageCheck.isMisusedVisibleForTesting(symbol)) {
            List<JavaFileScannerContext.Location> locations = symbol.usages().stream().filter(identifierTree -> !tree.equals(identifierTree)).map(identifierTree -> new JavaFileScannerContext.Location("usage of @VisibleForTesting in production", (Tree)identifierTree)).collect(Collectors.toList());
            this.reportIssue(identifier, String.format("Remove this usage of \"%s\", it is annotated with @VisibleForTesting and should not be accessed from production code.", identifier.name()), locations, null);
            this.reportedSymbols.add(symbol);
        }
    }

    private static boolean isMisusedVisibleForTesting(Symbol symbol) {
        Symbol owner = Objects.requireNonNull(symbol.owner(), "Owner is never null if unknown symbols are filtered out");
        return VisibleForTestingUsageCheck.isFieldMethodOrClass(symbol, owner) && !VisibleForTestingUsageCheck.inTheSameFile(symbol) && symbol.metadata().annotations().stream().anyMatch(VisibleForTestingUsageCheck::isVisibleForTestingAnnotation);
    }

    private static boolean isVisibleForTestingAnnotation(SymbolMetadata.AnnotationInstance annotationInstance) {
        return annotationInstance.symbol().name().equals("VisibleForTesting");
    }

    private static boolean inTheSameFile(Symbol symbol) {
        return symbol.declaration() != null;
    }

    private static boolean isFieldMethodOrClass(Symbol symbol, Symbol owner) {
        return symbol.isTypeSymbol() || owner.isTypeSymbol();
    }

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        this.reportedSymbols.clear();
        super.leaveFile(context);
    }
}

