/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00100", repositoryKey="squid")
@Rule(key="S100")
public class BadMethodNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the method names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (BadMethodNameCheck.isNotOverriden(methodTree) && !this.pattern.matcher(methodTree.simpleName().name()).matches()) {
            this.reportIssue(methodTree.simpleName(), "Rename this method name to match the regular expression '" + this.format + "'.");
        }
    }

    private static boolean isNotOverriden(MethodTree methodTree) {
        return Boolean.FALSE.equals(methodTree.isOverriding());
    }
}

