/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1201")
public class MethodNamedEqualsCheck
extends IssuableSubscriptionVisitor {
    private static final String EQUALS = "equals";
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("java.lang.Object").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (MethodNamedEqualsCheck.equalsWithSingleParam(methodTree) && !MethodNamedEqualsCheck.hasProperEquals(methodTree)) {
            this.reportIssue(methodTree.simpleName(), "Either override Object.equals(Object), or rename the method to prevent any confusion.");
        }
    }

    private static boolean equalsWithSingleParam(MethodTree methodTree) {
        return EQUALS.equalsIgnoreCase(methodTree.simpleName().name()) && methodTree.parameters().size() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasProperEquals(MethodTree methodTree) {
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        if (enclosingClass == null) return false;
        if (!enclosingClass.lookupSymbols(EQUALS).stream().anyMatch(EQUALS_MATCHER::matches)) return false;
        return true;
    }
}

