/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;

@Rule(key="S4434")
public class LDAPDeserializationCheck
extends AbstractMethodDetection {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CLASS_NAME = "javax.naming.directory.SearchControls";
    private static final int RET_OBJ_INDEX = 4;

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes(CLASS_NAME).names(CONSTRUCTOR_NAME).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(CLASS_NAME).names("setReturningObjFlag").addParametersMatcher("boolean").build());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkConstructorArguments(newClassTree.arguments());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        if (CONSTRUCTOR_NAME.equals(methodTree.symbol().name())) {
            this.checkConstructorArguments(methodTree.arguments());
        } else {
            ExpressionTree setValue = (ExpressionTree)methodTree.arguments().get(0);
            this.reportIfTrue(setValue);
        }
    }

    private void checkConstructorArguments(Arguments args) {
        if (args.size() <= 4) {
            return;
        }
        ExpressionTree retObjArgument = (ExpressionTree)args.get(4);
        this.reportIfTrue(retObjArgument);
    }

    private void reportIfTrue(ExpressionTree toUnderline) {
        if (LiteralUtils.isTrue(toUnderline)) {
            this.reportIssue(toUnderline, "Disable object deserialization.");
        }
    }
}

