/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5322")
public class ReceivingIntentsCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("android.content.Context").names("registerReceiver").withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().size() < 4 || ((ExpressionTree)mit.arguments().get(2)).is(Tree.Kind.NULL_LITERAL)) {
            this.reportIssue(mit.methodSelect(), "Make sure that intents are received safely here.");
        }
    }
}

