/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5042")
public class ZipEntryCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Make sure that expanding this archive file is safe here.";
    private static final MethodMatchers SENSITIVE_METHODS = MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.util.zip.ZipFile").names("entries").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("java.util.zip.ZipEntry").names("getSize").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("java.util.zip.ZipInputStream").names("getNextEntry").addWithoutParametersMatcher().build());
    private static final MethodMatchers INPUT_STREAM_READ = MethodMatchers.create().ofSubTypes("java.io.InputStream").names("read").withAnyParameters().build();
    private boolean isSafe = false;
    private boolean insideMethod = false;
    private final List<MethodInvocationTree> calls = new ArrayList<MethodInvocationTree>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            this.isSafe = false;
            this.calls.clear();
            this.insideMethod = true;
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (this.insideMethod && INPUT_STREAM_READ.matches(mit)) {
                this.isSafe = true;
            } else if (SENSITIVE_METHODS.matches(mit)) {
                if (this.insideMethod) {
                    this.calls.add(mit);
                } else {
                    this.report(mit);
                }
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            if (!this.isSafe) {
                for (MethodInvocationTree mit : this.calls) {
                    this.report(mit);
                }
            }
            this.insideMethod = false;
        }
    }

    private void report(MethodInvocationTree mit) {
        this.reportIssue(ExpressionUtils.methodName(mit), ISSUE_MESSAGE);
    }
}

