/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4488")
public class SpringComposedRequestMappingCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> PREFERRED_METHOD_MAP = SpringComposedRequestMappingCheck.buildPreferredMethodMap();

    private static Map<String, String> buildPreferredMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("GET", "@GetMapping");
        map.put("POST", "@PostMapping");
        map.put("PUT", "@PutMapping");
        map.put("PATCH", "@PatchMapping");
        map.put("DELETE", "@DeleteMapping");
        return map;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree requestMethod;
        String currentMethod;
        String preferredMethod;
        List methodValues;
        AnnotationTree annotation = (AnnotationTree)tree;
        if (annotation.symbolType().is("org.springframework.web.bind.annotation.RequestMapping") && (methodValues = annotation.arguments().stream().filter(argument -> "method".equals(SpringComposedRequestMappingCheck.attributeName(argument))).flatMap(SpringComposedRequestMappingCheck::extractValues).collect(Collectors.toList())).size() == 1 && (preferredMethod = PREFERRED_METHOD_MAP.get(currentMethod = SpringComposedRequestMappingCheck.getRequestMethodEnumEntry(requestMethod = (ExpressionTree)methodValues.get(0)))) != null) {
            this.reportIssue(annotation.annotationType(), "Replace \"@RequestMapping(method = RequestMethod." + currentMethod + ")\" with \"" + preferredMethod + "\"", Collections.singletonList(new JavaFileScannerContext.Location("", requestMethod)), null);
        }
    }

    private static String getRequestMethodEnumEntry(ExpressionTree requestMethod) {
        Symbol symbol;
        ExpressionTree expression = requestMethod;
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            expression = ((MemberSelectExpressionTree)requestMethod).identifier();
        }
        if (expression.is(Tree.Kind.IDENTIFIER) && (symbol = ((IdentifierTree)expression).symbol()).type().is("org.springframework.web.bind.annotation.RequestMethod")) {
            return symbol.name();
        }
        return "";
    }

    private static String attributeName(ExpressionTree expression) {
        if (expression.is(Tree.Kind.ASSIGNMENT)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
            return ((IdentifierTree)assignment.variable()).name();
        }
        return "value";
    }

    private static Stream<ExpressionTree> extractValues(ExpressionTree argument) {
        ExpressionTree expression = argument;
        if (expression.is(Tree.Kind.ASSIGNMENT)) {
            expression = ((AssignmentExpressionTree)expression).expression();
        }
        if (expression.is(Tree.Kind.NEW_ARRAY)) {
            return ((NewArrayTree)expression).initializers().stream().flatMap(SpringComposedRequestMappingCheck::extractValues);
        }
        return Stream.of(expression);
    }
}

