/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import org.sonar.java.filters.AnyRuleIssueFilter;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;

public class GeneratedCodeFilter
extends AnyRuleIssueFilter {
    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        super.scanFile(context);
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (GeneratedCodeFilter.isGenerated(tree.symbol())) {
            this.excludeLines(tree);
        }
        super.visitClass(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (GeneratedCodeFilter.isGenerated(tree.symbol())) {
            this.excludeLines(tree);
        }
        super.visitMethod(tree);
    }

    private static boolean isGenerated(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith("javax.annotation.Generated") || symbol.metadata().isAnnotatedWith("javax.annotation.processing.Generated");
    }
}

