/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.jsp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Options;
import org.apache.jasper.TrimSpacesOption;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TldCache;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.sonar.java.AnalysisException;
import org.xml.sax.SAXException;

class JasperOptions
implements Options {
    static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private final Path outputDir;
    private final TagPluginManager tagPluginManager;
    private final TldCache tldCache;
    private final JspConfig jspConfig;

    JasperOptions(JspCServletContext context, Path outputDir) {
        this(context, outputDir, new TldScanner(context, false, false, true));
    }

    JasperOptions(JspCServletContext context, Path outputDir, TldScanner tldScanner) {
        this.outputDir = outputDir;
        this.tagPluginManager = new TagPluginManager(context);
        this.tldCache = JasperOptions.initTldCache(context, tldScanner);
        this.jspConfig = new JspConfig(context);
    }

    private static TldCache initTldCache(JspCServletContext context, TldScanner tldScanner) {
        try {
            tldScanner.scan();
            return new TldCache(context, tldScanner.getUriTldResourcePathMap(), tldScanner.getTldResourcePathTaglibXmlMap());
        }
        catch (IOException | SAXException e) {
            throw new AnalysisException("Error scanning for TLD", e);
        }
    }

    @Override
    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return false;
    }

    @Override
    public boolean getKeepGenerated() {
        return true;
    }

    @Override
    public boolean isPoolingEnabled() {
        return false;
    }

    @Override
    public boolean getMappedFile() {
        return false;
    }

    @Override
    public boolean getClassDebugInfo() {
        return false;
    }

    @Override
    public int getCheckInterval() {
        return 0;
    }

    @Override
    public boolean getDevelopment() {
        return false;
    }

    @Override
    public boolean getDisplaySourceFragment() {
        return false;
    }

    @Override
    public boolean isSmapSuppressed() {
        return false;
    }

    @Override
    public boolean isSmapDumped() {
        return true;
    }

    @Override
    public TrimSpacesOption getTrimSpaces() {
        return TrimSpacesOption.FALSE;
    }

    @Override
    public String getIeClassId() {
        return DEFAULT_IE_CLASS_ID;
    }

    @Override
    public File getScratchDir() {
        return this.outputDir.toFile();
    }

    @Override
    public String getClassPath() {
        return null;
    }

    @Override
    public String getCompiler() {
        return null;
    }

    @Override
    public String getCompilerTargetVM() {
        return null;
    }

    @Override
    public String getCompilerSourceVM() {
        return null;
    }

    @Override
    public String getCompilerClassName() {
        return null;
    }

    @Override
    public TldCache getTldCache() {
        return this.tldCache;
    }

    @Override
    public String getJavaEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    @Override
    public boolean getFork() {
        return false;
    }

    @Override
    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    @Override
    public boolean isXpoweredBy() {
        return false;
    }

    @Override
    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    @Override
    public boolean genStringAsCharArray() {
        return false;
    }

    @Override
    public int getModificationTestInterval() {
        return 0;
    }

    @Override
    public boolean getRecompileOnFail() {
        return false;
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public Map<String, TagLibraryInfo> getCache() {
        return Collections.emptyMap();
    }

    @Override
    public int getMaxLoadedJsps() {
        return 0;
    }

    @Override
    public int getJspIdleTimeout() {
        return 0;
    }

    @Override
    public boolean getStrictQuoteEscaping() {
        return false;
    }

    @Override
    public boolean getQuoteAttributeEL() {
        return false;
    }
}

