/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.Preconditions;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ClassTreeImpl
extends JavaTree
implements ClassTree {
    private final Tree.Kind kind;
    private final SyntaxToken openBraceToken;
    private final List<Tree> members;
    private final SyntaxToken closeBraceToken;
    private ModifiersTree modifiers;
    private SyntaxToken atToken;
    private SyntaxToken declarationKeyword;
    private IdentifierTree simpleName;
    private TypeParameters typeParameters;
    private List<VariableTree> recordComponents = Collections.emptyList();
    @Nullable
    private SyntaxToken extendsKeyword;
    @Nullable
    private TypeTree superClass;
    @Nullable
    private SyntaxToken implementsKeyword;
    private ListTree<TypeTree> superInterfaces;
    private final ListTree<TypeTree> permittedTypes = QualifiedIdentifierListTreeImpl.emptyList();
    @Nullable
    public ITypeBinding typeBinding;

    public ClassTreeImpl(Tree.Kind kind, SyntaxToken openBraceToken, List<Tree> members, SyntaxToken closeBraceToken) {
        this.kind = kind;
        this.openBraceToken = openBraceToken;
        this.members = members;
        this.closeBraceToken = closeBraceToken;
        this.modifiers = ModifiersTreeImpl.emptyModifiers();
        this.typeParameters = new TypeParameterListTreeImpl();
        this.superInterfaces = QualifiedIdentifierListTreeImpl.emptyList();
    }

    public ClassTreeImpl(ModifiersTree modifiers, SyntaxToken openBraceToken, List<Tree> members, SyntaxToken closeBraceToken) {
        this.kind = Objects.requireNonNull(Tree.Kind.ANNOTATION_TYPE);
        this.modifiers = modifiers;
        this.typeParameters = new TypeParameterListTreeImpl();
        this.superClass = null;
        this.superInterfaces = QualifiedIdentifierListTreeImpl.emptyList();
        this.openBraceToken = openBraceToken;
        this.members = Objects.requireNonNull(members);
        this.closeBraceToken = closeBraceToken;
    }

    public ClassTreeImpl completeModifiers(ModifiersTreeImpl modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public ClassTreeImpl completeIdentifier(IdentifierTree identifier) {
        this.simpleName = identifier;
        return this;
    }

    public ClassTreeImpl completeTypeParameters(TypeParameterListTreeImpl typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public ClassTreeImpl completeSuperclass(SyntaxToken extendsKeyword, TypeTree superClass) {
        this.extendsKeyword = extendsKeyword;
        this.superClass = superClass;
        return this;
    }

    public ClassTreeImpl completeInterfaces(SyntaxToken keyword, QualifiedIdentifierListTreeImpl interfaces) {
        if (this.is(Tree.Kind.INTERFACE)) {
            this.extendsKeyword = keyword;
        } else {
            this.implementsKeyword = keyword;
        }
        this.superInterfaces = interfaces;
        return this;
    }

    public ClassTreeImpl complete(InternalSyntaxToken atToken, InternalSyntaxToken interfaceToken, IdentifierTree simpleName) {
        Preconditions.checkState(this.simpleName == null);
        this.completeIdentifier(simpleName);
        this.atToken = atToken;
        this.completeDeclarationKeyword(interfaceToken);
        return this;
    }

    public ClassTreeImpl completeDeclarationKeyword(SyntaxToken declarationKeyword) {
        this.declarationKeyword = declarationKeyword;
        return this;
    }

    public void completeRecordComponents(List<VariableTree> recordComponents) {
        this.recordComponents = recordComponents;
    }

    @Override
    public Tree.Kind kind() {
        return this.kind;
    }

    @Override
    @Nullable
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public TypeParameters typeParameters() {
        return this.typeParameters;
    }

    @Override
    public List<VariableTree> recordComponents() {
        return this.recordComponents;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    public TypeTree superClass() {
        return this.superClass;
    }

    @Override
    public ListTree<TypeTree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public ListTree<TypeTree> permittedTypes() {
        return this.permittedTypes;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.openBraceToken;
    }

    @Override
    public List<Tree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.closeBraceToken;
    }

    @Override
    public Symbol.TypeSymbol symbol() {
        return this.typeBinding != null ? this.root.sema.typeSymbol(this.typeBinding) : Symbols.unknownTypeSymbol;
    }

    @Override
    @Nullable
    public SyntaxToken declarationKeyword() {
        return this.declarationKeyword;
    }

    @Nullable
    public SyntaxToken atToken() {
        return this.atToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClass(this);
    }

    @Override
    public int getLine() {
        if (this.simpleName == null) {
            return super.getLine();
        }
        return ((IdentifierTreeImpl)this.simpleName).getLine();
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(Collections.singletonList(this.modifiers), ClassTreeImpl.addIfNotNull(this.atToken), ClassTreeImpl.addIfNotNull(this.declarationKeyword), ClassTreeImpl.addIfNotNull(this.simpleName), Collections.singletonList(this.typeParameters), this.recordComponents, ClassTreeImpl.addIfNotNull(this.extendsKeyword), ClassTreeImpl.addIfNotNull(this.superClass), ClassTreeImpl.addIfNotNull(this.implementsKeyword), Collections.singletonList(this.superInterfaces), Collections.singletonList(this.permittedTypes), Collections.singletonList(this.openBraceToken), this.members, Collections.singletonList(this.closeBraceToken));
    }

    private static Iterable<Tree> addIfNotNull(@Nullable Tree tree) {
        if (tree == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(tree);
    }
}

