/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.Preconditions;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class TypeCastExpressionTreeImpl
extends AssessableExpressionTree
implements TypeCastTree {
    private InternalSyntaxToken openParenToken;
    private final TypeTree type;
    @Nullable
    private final InternalSyntaxToken andToken;
    private final ListTree<Tree> bounds;
    private final InternalSyntaxToken closeParenToken;
    private final ExpressionTree expression;

    public TypeCastExpressionTreeImpl(TypeTree type, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        this.type = Objects.requireNonNull(type);
        this.bounds = BoundListTreeImpl.emptyList();
        this.closeParenToken = closeParenToken;
        this.expression = Objects.requireNonNull(expression);
        this.andToken = null;
    }

    public TypeCastExpressionTreeImpl(TypeTree type, InternalSyntaxToken andToken, ListTree<Tree> bounds, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        this.type = Objects.requireNonNull(type);
        this.bounds = bounds;
        this.closeParenToken = closeParenToken;
        this.expression = Objects.requireNonNull(expression);
        this.andToken = andToken;
    }

    public TypeCastExpressionTreeImpl complete(InternalSyntaxToken openParenToken) {
        Preconditions.checkState(this.openParenToken == null && this.closeParenToken != null);
        this.openParenToken = openParenToken;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TYPE_CAST;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    @Nullable
    public SyntaxToken andToken() {
        return this.andToken;
    }

    @Override
    public ListTree<Tree> bounds() {
        return this.bounds;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeCast(this);
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(Arrays.asList(this.openParenToken, this.type), this.andToken == null ? Collections.emptyList() : Collections.singletonList(this.andToken()), Arrays.asList(this.bounds, this.closeParenToken, this.expression));
    }
}

