/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.PerformanceMeasure;
import org.sonar.java.Preconditions;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.Sema;
import org.sonar.java.se.AlwaysTrueOrFalseExpressionCollector;
import org.sonar.java.se.CheckerDispatcher;
import org.sonar.java.se.ExceptionUtils;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.DivisionByZeroCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.NoWayOutLoopCheck;
import org.sonar.java.se.checks.NonNullSetToNullCheck;
import org.sonar.java.se.checks.NullDereferenceCheck;
import org.sonar.java.se.checks.OptionalGetBeforeIsPresentCheck;
import org.sonar.java.se.checks.RedundantAssignmentsCheck;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.StreamConsumedCheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SwitchExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class ExplodedGraphWalker {
    private static final int MAX_STEPS = 16000;
    public static final int MAX_NESTED_BOOLEAN_STATES = 10000;
    private static final int MAX_STARTING_STATES = 1024;
    private static final Set<String> THIS_SUPER = SetUtils.immutableSetOf("this", "super");
    @VisibleForTesting
    static final int MAX_EXEC_PROGRAM_POINT = 2;
    private static final MethodMatchers SYSTEM_EXIT_MATCHER = MethodMatchers.create().ofTypes("java.lang.System").names("exit").addParametersMatcher("int").build();
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatchers.NameBuilder JAVA_LANG_OBJECT_SUBTYPE = MethodMatchers.create().ofSubTypes("java.lang.Object");
    private static final MethodMatchers OBJECT_WAIT_MATCHER = JAVA_LANG_OBJECT_SUBTYPE.names("wait").addWithoutParametersMatcher().addParametersMatcher("long").addParametersMatcher("long", "int").build();
    private static final MethodMatchers GET_CLASS_MATCHER = JAVA_LANG_OBJECT_SUBTYPE.names("getClass").addWithoutParametersMatcher().build();
    private static final MethodMatchers THREAD_SLEEP_MATCHER = MethodMatchers.create().ofTypes("java.lang.Thread").names("sleep").withAnyParameters().build();
    private static final MethodMatchers EQUALS = MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("java.lang.Object").build();
    public static final MethodMatchers EQUALS_METHODS = MethodMatchers.or(EQUALS, MethodMatchers.create().ofTypes("java.util.Objects").names("equals").withAnyParameters().build());
    private final AlwaysTrueOrFalseExpressionCollector alwaysTrueOrFalseExpressionCollector;
    private MethodTree methodTree;
    private ExplodedGraph explodedGraph;
    @VisibleForTesting
    Deque<ExplodedGraph.Node> workList;
    ExplodedGraph.Node node;
    ProgramPoint programPosition;
    ProgramState programState;
    private LiveVariables liveVariables;
    @VisibleForTesting
    CheckerDispatcher checkerDispatcher;
    private CFG.Block exitBlock;
    private final Sema semanticModel;
    private final BehaviorCache behaviorCache;
    @VisibleForTesting
    int steps;
    ConstraintManager constraintManager;
    private boolean cleanup = true;
    @Nullable
    MethodBehavior methodBehavior;
    private Set<ExplodedGraph.Node> endOfExecutionPath;

    @VisibleForTesting
    public ExplodedGraphWalker(BehaviorCache behaviorCache, Sema semanticModel) {
        List<SECheck> checks = Arrays.asList(new NullDereferenceCheck(), new DivisionByZeroCheck(), new UnclosedResourcesCheck(), new LocksNotUnlockedCheck(), new NonNullSetToNullCheck(), new NoWayOutLoopCheck());
        this.alwaysTrueOrFalseExpressionCollector = new AlwaysTrueOrFalseExpressionCollector();
        this.checkerDispatcher = new CheckerDispatcher(this, checks);
        this.behaviorCache = behaviorCache;
        this.semanticModel = semanticModel;
    }

    @VisibleForTesting
    ExplodedGraphWalker(BehaviorCache behaviorCache, Sema semanticModel, boolean cleanup) {
        this(behaviorCache, semanticModel);
        this.cleanup = cleanup;
    }

    @VisibleForTesting
    protected ExplodedGraphWalker(List<SECheck> seChecks, BehaviorCache behaviorCache, Sema semanticModel) {
        this.alwaysTrueOrFalseExpressionCollector = new AlwaysTrueOrFalseExpressionCollector();
        this.checkerDispatcher = new CheckerDispatcher(this, seChecks);
        this.behaviorCache = behaviorCache;
        this.semanticModel = semanticModel;
    }

    public MethodBehavior visitMethod(MethodTree tree) {
        return this.visitMethod(tree, null);
    }

    public MethodBehavior visitMethod(MethodTree tree, @Nullable MethodBehavior methodBehavior) {
        Preconditions.checkArgument(methodBehavior == null || !methodBehavior.isComplete() || !methodBehavior.isVisited(), "Trying to execute an already visited methodBehavior");
        this.methodBehavior = methodBehavior;
        BlockTree body = tree.block();
        if (body != null) {
            this.execute(tree);
        }
        return this.methodBehavior;
    }

    private void execute(MethodTree tree) {
        PerformanceMeasure.Duration cfgDuration = PerformanceMeasure.start("cfg");
        CFG cfg = CFG.build(tree);
        this.exitBlock = cfg.exitBlock();
        cfgDuration.stop();
        this.checkerDispatcher.init(tree, cfg);
        PerformanceMeasure.Duration liveVariablesDuration = PerformanceMeasure.start("LiveVariables.analyze");
        this.liveVariables = LiveVariables.analyze(cfg);
        liveVariablesDuration.stop();
        this.explodedGraph = new ExplodedGraph();
        this.methodTree = tree;
        this.constraintManager = new ConstraintManager();
        this.workList = new LinkedList<ExplodedGraph.Node>();
        this.endOfExecutionPath = new LinkedHashSet<ExplodedGraph.Node>();
        this.programState = ProgramState.EMPTY_STATE;
        this.steps = 0;
        for (ProgramState startingState : this.startingStates(tree, this.programState)) {
            this.enqueue(new ProgramPoint(cfg.entryBlock()), startingState);
        }
        while (!this.workList.isEmpty()) {
            ++this.steps;
            if (this.steps > this.maxSteps()) {
                this.throwMaxSteps(tree);
            }
            this.setNode(this.workList.removeFirst());
            CFG.Block block = (CFG.Block)this.programPosition.block;
            if (block.successors().isEmpty()) {
                this.endOfExecutionPath.add(this.node);
                continue;
            }
            try {
                Tree terminator = block.terminator();
                if (this.programPosition.i < block.elements().size()) {
                    this.visit(block.elements().get(this.programPosition.i), terminator);
                    continue;
                }
                if (terminator == null) {
                    this.handleBlockExit(this.programPosition);
                    continue;
                }
                if (this.programPosition.i == block.elements().size()) {
                    PerformanceMeasure.Duration postStatementDuration = PerformanceMeasure.start("PostStatement");
                    this.checkerDispatcher.executeCheckPostStatement(terminator);
                    postStatementDuration.stop();
                    continue;
                }
                PerformanceMeasure.Duration preStatementDuration = PerformanceMeasure.start("PreStatement");
                this.checkerDispatcher.executeCheckPreStatement(terminator);
                preStatementDuration.stop();
                PerformanceMeasure.Duration handleBlockExitDuration = PerformanceMeasure.start("handleBlockExit");
                this.handleBlockExit(this.programPosition);
                handleBlockExitDuration.stop();
            }
            catch (TooManyNestedBooleanStatesException e) {
                this.throwTooManyBooleanStates(tree, e);
            }
            catch (RelationalSymbolicValue.TransitiveRelationExceededException e) {
                this.throwTooManyTransitiveRelationsException(tree, e);
            }
        }
        this.handleEndOfExecutionPath(false);
        PerformanceMeasure.Duration endOfExecutionDuration = PerformanceMeasure.start("EndOfExecution");
        this.checkerDispatcher.executeCheckEndOfExecution();
        endOfExecutionDuration.stop();
        this.workList = null;
        this.node = null;
        this.programState = null;
        this.constraintManager = null;
    }

    private void throwTooManyTransitiveRelationsException(MethodTree tree, RelationalSymbolicValue.TransitiveRelationExceededException e) {
        String message = String.format("reached maximum number of transitive relations generated for method %s in class %s", tree.simpleName().name(), tree.symbol().owner().name());
        MaximumStepsReachedException cause = new MaximumStepsReachedException(message, e);
        this.interrupted(cause);
        throw cause;
    }

    private void throwTooManyBooleanStates(MethodTree tree, TooManyNestedBooleanStatesException e) {
        String message = String.format("reached maximum number of %d branched states for method %s in class %s", 10000, tree.simpleName().name(), tree.symbol().owner().name());
        MaximumStepsReachedException cause = new MaximumStepsReachedException(message, e);
        this.interrupted(cause);
        throw cause;
    }

    private void throwMaxSteps(MethodTree tree) {
        String message = String.format("reached limit of %d steps for method %s#%d in class %s", this.maxSteps(), tree.simpleName().name(), tree.simpleName().firstToken().line(), tree.symbol().owner().name());
        MaximumStepsReachedException cause = new MaximumStepsReachedException(message);
        this.interrupted(cause);
        throw cause;
    }

    private void interrupted(Exception cause) {
        this.handleEndOfExecutionPath(true);
        this.checkerDispatcher.interruptedExecution(cause);
    }

    private void setNode(ExplodedGraph.Node node) {
        this.node = node;
        this.programPosition = this.node.programPoint;
        this.programState = this.node.programState;
    }

    private void handleEndOfExecutionPath(boolean interrupted) {
        ExplodedGraph.Node savedNode = this.node;
        this.endOfExecutionPath.forEach(n -> {
            this.setNode((ExplodedGraph.Node)n);
            this.checkerDispatcher.executeCheckEndOfExecutionPath(this.constraintManager);
            if (!interrupted && this.methodBehavior != null) {
                this.methodBehavior.createYield(this.node);
            }
        });
        this.setNode(savedNode);
    }

    public void addExceptionalYield(SymbolicValue target, ProgramState exceptionalState, String exceptionFullyQualifiedName, SECheck check) {
        if (this.methodBehavior != null && this.methodBehavior.parameters().contains(target)) {
            Type exceptionType = this.semanticModel.getClassType(exceptionFullyQualifiedName);
            ProgramState newExceptionalState = exceptionalState.clearStack().stackValue(this.constraintManager.createExceptionalSymbolicValue(exceptionType));
            ExplodedGraph.Node exitNode = this.explodedGraph.node(this.node.programPoint, newExceptionalState);
            this.methodBehavior.createExceptionalCheckBasedYield(target, exitNode, exceptionFullyQualifiedName, check);
            exitNode.addParent(this.node, null);
        }
    }

    private Iterable<ProgramState> startingStates(MethodTree tree, ProgramState currentState) {
        Stream<ProgramState> stateStream = Stream.of(currentState);
        int numberStartingStates = 1;
        boolean isEqualsMethod = EQUALS.matches(tree);
        boolean nonNullParameters = NullableAnnotationUtils.isGloballyAnnotatedParameterNonNull(this.methodTree.symbol());
        boolean nullableParameters = NullableAnnotationUtils.isGloballyAnnotatedParameterNullable(this.methodTree.symbol());
        boolean hasMethodBehavior = this.methodBehavior != null;
        for (VariableTree variableTree : tree.parameters()) {
            SymbolicValue sv = this.constraintManager.createSymbolicValue(variableTree);
            Symbol variableSymbol = variableTree.symbol();
            if (hasMethodBehavior) {
                this.methodBehavior.addParameter(sv);
            }
            stateStream = stateStream.map(ps -> ps.put(variableSymbol, sv));
            if (isEqualsMethod || ExplodedGraphWalker.parameterCanBeNull(variableSymbol, nullableParameters)) {
                if ((numberStartingStates *= 2) > 1024) {
                    ExplodedGraphWalker.throwMaximumStartingStates(this.methodTree);
                }
                stateStream = stateStream.flatMap(ps -> Stream.concat(sv.setConstraint((ProgramState)ps, ObjectConstraint.NULL).stream(), sv.setConstraint((ProgramState)ps, ObjectConstraint.NOT_NULL).stream()));
                continue;
            }
            if (!nonNullParameters && !NullableAnnotationUtils.isAnnotatedNonNull(variableSymbol)) continue;
            stateStream = stateStream.flatMap(ps -> sv.setConstraint((ProgramState)ps, ObjectConstraint.NOT_NULL).stream());
        }
        return stateStream.collect(Collectors.toList());
    }

    private static void throwMaximumStartingStates(MethodTree tree) {
        String message = String.format("reached maximum number of %d starting states for method %s in class %s", 1024, tree.simpleName().name(), tree.symbol().owner().name());
        throw new MaximumStartingStatesException(message);
    }

    private static boolean parameterCanBeNull(Symbol variableSymbol, boolean nullableParameters) {
        if (variableSymbol.type().isPrimitive()) {
            return false;
        }
        return NullableAnnotationUtils.isAnnotatedNullable(variableSymbol.metadata()) || nullableParameters && !NullableAnnotationUtils.isAnnotatedNonNull(variableSymbol);
    }

    private void cleanUpProgramState(CFG.Block block) {
        if (this.cleanup) {
            List<SymbolicValue> protectedSVs = this.methodBehavior == null ? Collections.emptyList() : this.methodBehavior.parameters();
            this.programState = this.programState.cleanupDeadSymbols(this.liveVariables.getOut(block), protectedSVs);
            this.programState = this.programState.cleanupConstraints(protectedSVs);
        }
    }

    private void handleBlockExit(ProgramPoint programPosition) {
        CFG.Block block = (CFG.Block)programPosition.block;
        Tree terminator = block.terminator();
        this.cleanUpProgramState(block);
        boolean exitPath = this.node.exitPath;
        if (terminator != null) {
            switch (terminator.kind()) {
                case IF_STATEMENT: {
                    ExpressionTree ifCondition = ((IfStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(ifCondition), ExplodedGraphWalker.verifyCondition(ifCondition));
                    return;
                }
                case SWITCH_STATEMENT: {
                    this.handleSwitch(block, ((SwitchStatementTree)terminator).cases());
                    return;
                }
                case SWITCH_EXPRESSION: {
                    this.handleSwitch(block, ((SwitchExpressionTree)terminator).cases());
                    return;
                }
                case CONDITIONAL_OR: 
                case CONDITIONAL_AND: {
                    this.handleBranch(block, ((BinaryExpressionTree)terminator).leftOperand());
                    return;
                }
                case CONDITIONAL_EXPRESSION: {
                    this.handleBranch(block, ((ConditionalExpressionTree)terminator).condition());
                    return;
                }
                case FOR_STATEMENT: {
                    ExpressionTree condition = ((ForStatementTree)terminator).condition();
                    if (condition == null) break;
                    this.handleBranch(block, condition, false);
                    return;
                }
                case WHILE_STATEMENT: {
                    ExpressionTree whileCondition = ((WhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(whileCondition), ExplodedGraphWalker.verifyCondition(whileCondition));
                    return;
                }
                case DO_STATEMENT: {
                    ExpressionTree doCondition = ((DoWhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(doCondition), ExplodedGraphWalker.verifyCondition(doCondition));
                    return;
                }
                case SYNCHRONIZED_STATEMENT: {
                    this.resetFieldValues(false);
                    break;
                }
                case RETURN_STATEMENT: {
                    ExpressionTree returnExpression = ((ReturnStatementTree)terminator).expression();
                    if (returnExpression == null) break;
                    this.programState.storeExitValue();
                    break;
                }
                case THROW_STATEMENT: {
                    ProgramState.Pop unstack = this.programState.unstackValue(1);
                    SymbolicValue sv = unstack.values.get(0);
                    sv = sv instanceof SymbolicValue.CaughtExceptionSymbolicValue ? ((SymbolicValue.CaughtExceptionSymbolicValue)sv).exception() : this.constraintManager.createExceptionalSymbolicValue(((ThrowStatementTree)terminator).expression().symbolType());
                    this.programState = unstack.state.stackValue(sv);
                    this.programState.storeExitValue();
                    break;
                }
            }
        }
        if (exitPath) {
            if (block.exitBlock() != null) {
                this.enqueue(new ProgramPoint(block.exitBlock()), this.programState, true);
            } else {
                for (CFG.Block successor : block.successors()) {
                    this.enqueue(new ProgramPoint(successor), this.programState, true);
                }
            }
        } else {
            for (CFG.Block successor : block.successors()) {
                if (block.isFinallyBlock() && !ExplodedGraphWalker.isDirectFlowSuccessorOf(successor, block)) continue;
                this.enqueue(new ProgramPoint(successor), this.programState, successor == block.exitBlock());
            }
        }
    }

    private static boolean verifyCondition(ExpressionTree condition) {
        IdentifierTree identifierTree;
        if (condition.is(Tree.Kind.IDENTIFIER) && (identifierTree = (IdentifierTree)condition).symbol().isFinal() && identifierTree.symbol().isVariableSymbol()) {
            VariableTree declaration = (VariableTree)identifierTree.symbol().declaration();
            return declaration == null || declaration.initializer() == null || !declaration.initializer().is(Tree.Kind.BOOLEAN_LITERAL);
        }
        return !condition.is(Tree.Kind.BOOLEAN_LITERAL);
    }

    private static boolean isDirectFlowSuccessorOf(CFG.Block successor, CFG.Block block) {
        return successor != block.exitBlock() || block.successors().size() == 1 && successor.isMethodExitBlock();
    }

    private static ExpressionTree cleanupCondition(ExpressionTree condition) {
        ExpressionTree cleanedUpCondition = ExpressionUtils.skipParentheses(condition);
        if (cleanedUpCondition.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            cleanedUpCondition = ExplodedGraphWalker.cleanupCondition(((BinaryExpressionTree)cleanedUpCondition).rightOperand());
        }
        return cleanedUpCondition;
    }

    private void handleSwitch(CFG.Block programPosition, List<CaseGroupTree> caseGroups) {
        ProgramState state = this.programState;
        HashMap<CaseGroupTree, List<ProgramState.SymbolicValueSymbol>> caseValues = new HashMap<CaseGroupTree, List<ProgramState.SymbolicValueSymbol>>();
        for (CaseGroupTree caseGroup : ListUtils.reverse(caseGroups)) {
            int numberOfCaseValues = caseGroup.labels().stream().map(CaseLabelTree::expressions).mapToInt(List::size).sum();
            ProgramState.Pop poppedCaseValues = state.unstackValue(numberOfCaseValues);
            state = poppedCaseValues.state;
            caseValues.put(caseGroup, poppedCaseValues.valuesAndSymbols);
        }
        ProgramState.Pop poppedSwitchValue = state.unstackValue(1);
        ProgramState.SymbolicValueSymbol switchValue = poppedSwitchValue.valuesAndSymbols.get(0);
        ProgramState elseState = poppedSwitchValue.state;
        CFG.Block elseBlock = null;
        for (CFG.Block successor : programPosition.successors()) {
            CaseGroupTree caseGroup = successor.caseGroup();
            if (caseGroup == null || !caseValues.containsKey(caseGroup)) {
                Preconditions.checkState(elseBlock == null);
                elseBlock = successor;
                continue;
            }
            for (ProgramState.SymbolicValueSymbol caseValue : (List)caseValues.get(caseGroup)) {
                SymbolicValue equality = this.constraintManager.createEquality(switchValue, caseValue);
                ProgramState ps = ExplodedGraphWalker.setConstraint(state, equality, BooleanConstraint.TRUE);
                this.enqueue(new ProgramPoint(successor), ps, this.node.exitPath);
                elseState = ExplodedGraphWalker.setConstraint(elseState, equality, BooleanConstraint.FALSE);
            }
            if (!successor.isDefaultBlock()) continue;
            Preconditions.checkState(elseBlock == null);
            elseBlock = successor;
        }
        if (elseBlock != null) {
            this.enqueue(new ProgramPoint(elseBlock), elseState, this.node.exitPath);
        }
    }

    private static ProgramState setConstraint(ProgramState state, SymbolicValue condition, BooleanConstraint constraint) {
        List<ProgramState> states = condition.setConstraint(state, constraint);
        if (states.isEmpty()) {
            return state;
        }
        Preconditions.checkState(states.size() == 1);
        return states.get(0);
    }

    private void handleBranch(CFG.Block programPosition, Tree condition) {
        this.handleBranch(programPosition, condition, true);
    }

    private void handleBranch(CFG.Block programPosition, Tree condition, boolean checkPath) {
        Pair<List<ProgramState>, List<ProgramState>> pair = this.constraintManager.assumeDual(this.programState);
        ProgramPoint falseBlockProgramPoint = new ProgramPoint(programPosition.falseBlock());
        Iterator iterator = ((List)pair.a).iterator();
        while (iterator.hasNext()) {
            ProgramState state;
            ProgramState ps = state = (ProgramState)iterator.next();
            if (condition.parent().is(Tree.Kind.CONDITIONAL_AND) && !ExplodedGraphWalker.isPartOfConditionalExpressionCondition(condition)) {
                ps = state.stackValue(SymbolicValue.FALSE_LITERAL);
            }
            this.enqueue(falseBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseExpressionCollector.evaluatedToFalse(ExplodedGraphWalker.cleanupCondition((ExpressionTree)condition), this.node);
        }
        ProgramPoint trueBlockProgramPoint = new ProgramPoint(programPosition.trueBlock());
        Iterator iterator2 = ((List)pair.b).iterator();
        while (iterator2.hasNext()) {
            ProgramState state;
            ProgramState ps = state = (ProgramState)iterator2.next();
            if (condition.parent().is(Tree.Kind.CONDITIONAL_OR) && !ExplodedGraphWalker.isPartOfConditionalExpressionCondition(condition)) {
                ps = state.stackValue(SymbolicValue.TRUE_LITERAL);
            }
            this.enqueue(trueBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseExpressionCollector.evaluatedToTrue(ExplodedGraphWalker.cleanupCondition((ExpressionTree)condition), this.node);
        }
    }

    private static boolean isPartOfConditionalExpressionCondition(Tree tree) {
        Tree current;
        Tree parent = tree;
        do {
            current = parent;
        } while ((parent = parent.parent()).is(Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR));
        return parent.is(Tree.Kind.CONDITIONAL_EXPRESSION) && current.equals(((ConditionalExpressionTree)parent).condition());
    }

    private void visit(Tree tree, @Nullable Tree terminator) {
        if (!this.checkerDispatcher.executeCheckPreStatement(tree)) {
            return;
        }
        switch (tree.kind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (SYSTEM_EXIT_MATCHER.matches(mit)) {
                    return;
                }
                this.executeMethodInvocation(mit);
                return;
            }
            case SWITCH_STATEMENT: 
            case LABELED_STATEMENT: 
            case EXPRESSION_STATEMENT: 
            case PARENTHESIZED_EXPRESSION: {
                throw new IllegalStateException("Cannot appear in CFG: " + tree.kind().name());
            }
            case VARIABLE: {
                this.executeVariable((VariableTree)tree, terminator);
                break;
            }
            case TYPE_CAST: {
                this.executeTypeCast((TypeCastTree)tree);
                break;
            }
            case ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                this.executeAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                this.executeLogicalAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.executeArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.executeNewArray((NewArrayTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.executeNewClass((NewClassTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.executeBinaryExpression(tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case INSTANCE_OF: {
                this.executeUnaryExpression(tree);
                break;
            }
            case IDENTIFIER: {
                this.executeIdentifier((IdentifierTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.executeMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHAR_LITERAL: 
            case TEXT_BLOCK: 
            case STRING_LITERAL: {
                SymbolicValue val = this.constraintManager.createSymbolicValue(tree);
                this.programState = this.programState.stackValue(val);
                this.programState = this.programState.addConstraint(val, ObjectConstraint.NOT_NULL);
                break;
            }
            case BOOLEAN_LITERAL: {
                boolean value = Boolean.parseBoolean(((LiteralTree)tree).value());
                this.programState = this.programState.stackValue(value ? SymbolicValue.TRUE_LITERAL : SymbolicValue.FALSE_LITERAL);
                break;
            }
            case NULL_LITERAL: {
                this.programState = this.programState.stackValue(SymbolicValue.NULL_LITERAL);
                break;
            }
            case SWITCH_EXPRESSION: 
            case LAMBDA_EXPRESSION: 
            case METHOD_REFERENCE: {
                this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
                break;
            }
            case ASSERT_STATEMENT: {
                this.executeAssertStatement(tree);
                return;
            }
        }
        this.checkerDispatcher.executeCheckPostStatement(tree);
        this.clearStack(tree);
    }

    private void executeAssertStatement(Tree tree) {
        ProgramState.Pop pop = this.programState.unstackValue(1);
        pop.values.forEach(v -> v.setConstraint(pop.state, BooleanConstraint.TRUE).forEach(ps -> {
            this.checkerDispatcher.syntaxNode = tree;
            this.checkerDispatcher.addTransition((ProgramState)ps);
            ps.clearStack();
        }));
    }

    private void executeMethodInvocation(MethodInvocationTree mit) {
        this.setSymbolicValueOnFields(mit);
        ProgramState.Pop unstack = this.programState.unstackValue(mit.arguments().size() + 1);
        this.programState = unstack.state;
        MethodBehavior methodInvokedBehavior = null;
        Symbol methodSymbol = mit.symbol();
        if (methodSymbol.isMethodSymbol()) {
            methodInvokedBehavior = this.behaviorCache.get((Symbol.MethodSymbol)methodSymbol);
        }
        this.enqueueUncheckedExceptionalPaths(methodSymbol);
        SymbolicValue resultValue = this.constraintManager.createMethodSymbolicValue(mit, unstack.valuesAndSymbols);
        if (methodInvokedBehavior != null && methodInvokedBehavior.isComplete() && !EQUALS_METHODS.matches(mit)) {
            List<SymbolicValue> invocationArguments = ExplodedGraphWalker.invocationArguments(unstack.values);
            List invocationTypes = mit.arguments().stream().map(ExpressionTree::symbolType).collect(Collectors.toList());
            HashMap thrownExceptionsByExceptionType = new HashMap();
            methodInvokedBehavior.exceptionalPathYields().forEach(methodYield -> methodYield.statesAfterInvocation(invocationArguments, invocationTypes, this.programState, () -> thrownExceptionsByExceptionType.computeIfAbsent(methodYield.exceptionType(this.semanticModel), this.constraintManager::createExceptionalSymbolicValue)).forEach(psYield -> this.enqueueExceptionalPaths((ProgramState)psYield, methodSymbol, (MethodYield)methodYield)));
            methodInvokedBehavior.happyPathYields().forEach(methodYield -> methodYield.statesAfterInvocation(invocationArguments, invocationTypes, this.programState, () -> resultValue).map(psYield -> this.handleSpecialMethods((ProgramState)psYield, mit)).forEach(psYield -> this.enqueueHappyPath((ProgramState)psYield, mit, (MethodYield)methodYield)));
        } else {
            this.enqueueThrownExceptionalPaths(methodSymbol);
            this.programState = this.handleSpecialMethods(this.programState.stackValue(resultValue), mit);
            this.checkerDispatcher.executeCheckPostStatement(mit);
            this.clearStack(mit);
        }
    }

    private void enqueueHappyPath(ProgramState programState, MethodInvocationTree mit, MethodYield methodYield) {
        this.checkerDispatcher.syntaxNode = mit;
        this.checkerDispatcher.methodYield = methodYield;
        this.checkerDispatcher.addTransition(programState);
        this.checkerDispatcher.methodYield = null;
        this.clearStack(mit);
    }

    private ProgramState handleSpecialMethods(ProgramState ps, MethodInvocationTree mit) {
        if (NullableAnnotationUtils.isAnnotatedNonNull(mit.symbol())) {
            return ps.addConstraint(ps.peekValue(), ObjectConstraint.NOT_NULL);
        }
        if (OBJECT_WAIT_MATCHER.matches(mit)) {
            return ps.resetFieldValues(this.constraintManager, false);
        }
        return ps;
    }

    private void enqueueThrownExceptionalPaths(Symbol symbol) {
        if (!symbol.isMethodSymbol()) {
            return;
        }
        ProgramState ps = this.programState.clearStack();
        ((Symbol.MethodSymbol)symbol).thrownTypes().stream().map(this.constraintManager::createExceptionalSymbolicValue).map(ps::stackValue).forEach(ps1 -> this.enqueueExceptionalPaths((ProgramState)ps1, symbol));
    }

    private void enqueueUncheckedExceptionalPaths(Symbol methodSymbol) {
        this.enqueueExceptionalPaths(this.programState.clearStack().stackValue(this.constraintManager.createExceptionalSymbolicValue(null)), methodSymbol);
    }

    private void enqueueExceptionalPaths(ProgramState ps, Symbol methodSymbol) {
        this.enqueueExceptionalPaths(ps, methodSymbol, null);
    }

    private void enqueueExceptionalPaths(ProgramState ps, Symbol methodSymbol, @Nullable MethodYield methodYield) {
        Set<CFG.Block> exceptionBlocks = ((CFG.Block)this.node.programPoint.block).exceptions();
        List catchBlocks = exceptionBlocks.stream().filter(CFG.Block.IS_CATCH_BLOCK).collect(Collectors.toList());
        SymbolicValue peekValue = ps.peekValue();
        Preconditions.checkState(peekValue instanceof SymbolicValue.ExceptionalSymbolicValue, "Top of stack should always contains exceptional SV");
        SymbolicValue.ExceptionalSymbolicValue exceptionSV = (SymbolicValue.ExceptionalSymbolicValue)peekValue;
        List<CFG.Block> caughtBlocks = catchBlocks.stream().filter(b -> ExplodedGraphWalker.isCaughtByBlock(exceptionSV.exceptionType(), b)).sorted((b1, b2) -> Integer.compare(b2.id(), b1.id())).collect(Collectors.toList());
        if (!caughtBlocks.isEmpty()) {
            caughtBlocks.forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), ps, methodYield));
            return;
        }
        catchBlocks.stream().filter(ExplodedGraphWalker::isCatchingUncheckedException).forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), ps, methodYield));
        ps.storeExitValue();
        List<CFG.Block> otherBlocks = exceptionBlocks.stream().filter(CFG.Block.IS_CATCH_BLOCK.negate().or(b -> methodSymbol.isUnknown())).collect(Collectors.toList());
        if (otherBlocks.isEmpty()) {
            CFG.Block methodExit = this.node.programPoint.block.successors().stream().map(b -> (CFG.Block)b).filter(CFG.Block::isMethodExitBlock).findFirst().orElse(this.exitBlock);
            this.enqueue(new ProgramPoint(methodExit), ps, true, methodYield);
        } else {
            otherBlocks.forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), ps, true, methodYield));
        }
    }

    private static boolean isCaughtByBlock(@Nullable Type thrownType, CFG.Block catchBlock) {
        if (thrownType != null) {
            Type caughtType = ((VariableTree)catchBlock.elements().get(0)).symbol().type();
            return thrownType.isSubtypeOf(caughtType) || caughtType.isSubtypeOf(thrownType);
        }
        return false;
    }

    private static boolean isCatchingUncheckedException(CFG.Block catchBlock) {
        Type caughtType = ((VariableTree)catchBlock.elements().get(0)).symbol().type();
        return ExceptionUtils.isUncheckedException(caughtType);
    }

    private static List<SymbolicValue> invocationArguments(List<SymbolicValue> values) {
        return ListUtils.reverse(values.subList(0, values.size() - 1));
    }

    private void executeVariable(VariableTree variableTree, @Nullable Tree terminator) {
        Symbol variableSymbol = variableTree.symbol();
        if (variableTree.initializer() == null) {
            SymbolicValue sv = null;
            if (terminator != null && terminator.is(Tree.Kind.FOR_EACH_STATEMENT)) {
                sv = this.constraintManager.createSymbolicValue(variableTree);
                if (NullableAnnotationUtils.isAnnotatedNonNull(variableSymbol)) {
                    this.programState = this.programState.addConstraint(sv, ObjectConstraint.NOT_NULL);
                }
            } else if (variableTree.parent().is(Tree.Kind.CATCH)) {
                sv = this.handleCatchVariable(variableSymbol.type());
                this.programState = this.programState.clearStack();
                this.programState = this.programState.addConstraint(sv, ObjectConstraint.NOT_NULL);
            }
            if (sv != null) {
                this.programState = this.programState.put(variableSymbol, sv);
            }
        } else {
            ProgramState.Pop unstack = this.programState.unstackValue(1);
            this.programState = unstack.state;
            this.programState = this.programState.put(variableSymbol, unstack.values.get(0));
        }
    }

    private SymbolicValue handleCatchVariable(Type caughtType) {
        SymbolicValue peekValue = this.programState.peekValue();
        SymbolicValue.ExceptionalSymbolicValue sv = null;
        Type exceptionType = null;
        if (peekValue instanceof SymbolicValue.ExceptionalSymbolicValue) {
            sv = (SymbolicValue.ExceptionalSymbolicValue)peekValue;
            exceptionType = sv.exceptionType();
        }
        if (exceptionType == null || exceptionType.isUnknown()) {
            sv = this.constraintManager.createExceptionalSymbolicValue(caughtType);
        }
        return this.constraintManager.createCaughtExceptionSymbolicValue(sv);
    }

    private void executeTypeCast(TypeCastTree typeCast) {
        Type type = typeCast.type().symbolType();
        if (type.isPrimitive()) {
            Type expType = typeCast.expression().symbolType();
            SymbolicValue castSV = this.constraintManager.createSymbolicValue(typeCast);
            if (!expType.isPrimitive() || expType != type && !expType.isSubtypeOf(type)) {
                ProgramState.Pop unstack = this.programState.unstackValue(1);
                this.programState = unstack.state;
                this.programState = this.programState.stackValue(castSV);
            }
        }
    }

    private void executeAssignment(AssignmentExpressionTree tree) {
        SymbolicValue value;
        ProgramState.Pop unstack;
        if (tree.is(Tree.Kind.ASSIGNMENT)) {
            unstack = ExpressionUtils.isSimpleAssignment(tree) ? this.programState.unstackValue(1) : this.programState.unstackValue(2);
            value = unstack.values.get(0);
        } else {
            unstack = this.programState.unstackValue(2);
            value = this.constraintManager.createSymbolicValue(tree);
        }
        this.programState = unstack.state;
        Symbol symbol = null;
        if (tree.variable().is(Tree.Kind.IDENTIFIER) || ExpressionUtils.isSelectOnThisOrSuper(tree)) {
            symbol = ExpressionUtils.extractIdentifier(tree).symbol();
            this.programState = this.programState.put(symbol, value);
        }
        this.programState = this.programState.stackValue(value, symbol);
    }

    private void executeLogicalAssignment(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            ProgramState.Pop unstack = this.programState.unstackValue(2);
            ProgramState.SymbolicValueSymbol assignedTo = unstack.valuesAndSymbols.get(1);
            ProgramState.SymbolicValueSymbol value = unstack.valuesAndSymbols.get(0);
            this.programState = unstack.state;
            SymbolicValue symbolicValue = this.constraintManager.createBinarySymbolicValue(tree, Arrays.asList(assignedTo, value));
            Symbol symbol = ((IdentifierTree)variable).symbol();
            this.programState = this.programState.stackValue(symbolicValue, symbol);
            this.programState = this.programState.put(symbol, symbolicValue);
        }
    }

    private void executeArrayAccessExpression(ArrayAccessExpressionTree tree) {
        ProgramState.Pop unstack = this.programState.unstackValue(2);
        this.programState = unstack.state;
        this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
    }

    private void executeNewArray(NewArrayTree newArrayTree) {
        int numberDimensions = (int)newArrayTree.dimensions().stream().map(ArrayDimensionTree::expression).filter(Objects::nonNull).count();
        this.programState = this.programState.unstackValue((int)numberDimensions).state;
        this.programState = this.programState.unstackValue((int)newArrayTree.initializers().size()).state;
        SymbolicValue svNewArray = this.constraintManager.createSymbolicValue(newArrayTree);
        this.programState = this.programState.stackValue(svNewArray);
        this.programState = svNewArray.setSingleConstraint(this.programState, ObjectConstraint.NOT_NULL);
    }

    private void executeNewClass(NewClassTree newClassTree) {
        this.programState = this.programState.unstackValue((int)newClassTree.arguments().size()).state;
        Symbol symbol = newClassTree.constructorSymbol();
        if (((CFG.Block)this.node.programPoint.block).exceptions().stream().anyMatch(CFG.Block.IS_CATCH_BLOCK)) {
            this.enqueueUncheckedExceptionalPaths(symbol);
        }
        this.enqueueThrownExceptionalPaths(symbol);
        SymbolicValue svNewClass = this.constraintManager.createSymbolicValue(newClassTree);
        this.programState = this.programState.stackValue(svNewClass);
        this.programState = svNewClass.setSingleConstraint(this.programState, ObjectConstraint.NOT_NULL);
    }

    private void executeBinaryExpression(Tree tree) {
        ProgramState.Pop unstackBinary = this.programState.unstackValue(2);
        this.programState = unstackBinary.state;
        SymbolicValue symbolicValue = this.constraintManager.createBinarySymbolicValue(tree, unstackBinary.valuesAndSymbols);
        this.programState = this.programState.addConstraint(symbolicValue, ObjectConstraint.NOT_NULL);
        this.programState = this.programState.stackValue(symbolicValue);
    }

    private void executeUnaryExpression(Tree tree) {
        ProgramState.Pop unstackUnary = this.programState.unstackValue(1);
        this.programState = unstackUnary.state;
        SymbolicValue unarySymbolicValue = this.constraintManager.createSymbolicValue(tree);
        unarySymbolicValue.computedFrom(unstackUnary.valuesAndSymbols);
        ProgramState.SymbolicValueSymbol symbolicValueSymbol = unstackUnary.valuesAndSymbols.get(0);
        this.programState = tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT) ? this.programState.stackValue(symbolicValueSymbol.sv, symbolicValueSymbol.symbol) : this.programState.stackValue(unarySymbolicValue);
        if (tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT) && symbolicValueSymbol.symbol != null) {
            this.programState = this.programState.put(symbolicValueSymbol.symbol, unarySymbolicValue);
        }
    }

    private void executeIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        SymbolicValue value = this.programState.getValue(symbol);
        if (value == null) {
            value = this.constraintManager.createSymbolicValue(tree);
            this.programState = this.programState.stackValue(value, symbol);
            this.learnIdentifierConstraints(tree, value);
        } else {
            this.programState = this.programState.stackValue(value, symbol);
        }
        this.programState = this.programState.put(symbol, value);
    }

    private void learnIdentifierConstraints(IdentifierTree tree, SymbolicValue sv) {
        if (THIS_SUPER.contains(tree.name())) {
            this.programState = this.programState.addConstraint(sv, ObjectConstraint.NOT_NULL);
            return;
        }
        Tree declaration = tree.symbol().declaration();
        if (!ExplodedGraphWalker.isFinalField(tree.symbol()) || declaration == null) {
            return;
        }
        VariableTree variableTree = (VariableTree)declaration;
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null) {
            return;
        }
        if ((initializer = ExpressionUtils.skipParentheses(initializer)).is(Tree.Kind.NULL_LITERAL)) {
            this.programState = this.programState.addConstraint(sv, ObjectConstraint.NULL);
        } else if (initializer.is(Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY, Tree.Kind.STRING_LITERAL) || ExplodedGraphWalker.isNonNullMethodInvocation(initializer) || variableTree.symbol().type().isPrimitive() || initializer.symbolType().isPrimitive()) {
            this.programState = this.programState.addConstraint(sv, ObjectConstraint.NOT_NULL);
        }
    }

    private static boolean isFinalField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.isFinal() && symbol.owner().isTypeSymbol();
    }

    private static boolean isNonNullMethodInvocation(ExpressionTree expr) {
        return expr.is(Tree.Kind.METHOD_INVOCATION) && NullableAnnotationUtils.isAnnotatedNonNull(((MethodInvocationTree)expr).symbol());
    }

    private void executeMemberSelect(MemberSelectExpressionTree mse) {
        if (!"class".equals(mse.identifier().name())) {
            ProgramState.Pop unstackMSE = this.programState.unstackValue(1);
            this.programState = unstackMSE.state;
        }
        if (ExpressionUtils.isSelectOnThisOrSuper(mse)) {
            this.executeIdentifier(mse.identifier());
        } else {
            SymbolicValue mseValue = this.constraintManager.createSymbolicValue(mse);
            this.programState = this.programState.stackValue(mseValue);
        }
    }

    public void clearStack(Tree tree) {
        if (tree.parent().is(Tree.Kind.EXPRESSION_STATEMENT)) {
            this.programState = this.programState.clearStack();
        }
    }

    private void setSymbolicValueOnFields(MethodInvocationTree tree) {
        boolean threadSleepMatch = THREAD_SLEEP_MATCHER.matches(tree);
        boolean providingThisAsArgument = ExplodedGraphWalker.isProvidingThisAsArgument(tree);
        if (ExplodedGraphWalker.isLocalMethodInvocation(tree) || providingThisAsArgument || threadSleepMatch) {
            boolean resetOnlyStaticFields = tree.symbol().isStatic() && !threadSleepMatch && !providingThisAsArgument;
            this.resetFieldValues(resetOnlyStaticFields);
        }
    }

    private static boolean isLocalMethodInvocation(MethodInvocationTree tree) {
        if (GET_CLASS_MATCHER.matches(tree)) {
            return false;
        }
        ExpressionTree methodSelect = tree.methodSelect();
        if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            return true;
        }
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelectExpression = (MemberSelectExpressionTree)methodSelect;
            ExpressionTree target = memberSelectExpression.expression();
            if (target.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)target;
                return THIS_SUPER.contains(identifier.name());
            }
        }
        return false;
    }

    private static boolean isProvidingThisAsArgument(MethodInvocationTree tree) {
        return tree.arguments().stream().anyMatch(ExpressionUtils::isThis);
    }

    private void resetFieldValues(boolean resetOnlyStaticFields) {
        this.programState = this.programState.resetFieldValues(this.constraintManager, resetOnlyStaticFields);
    }

    public void enqueue(ProgramPoint programPoint, ProgramState programState) {
        this.enqueue(programPoint, programState, false);
    }

    public void enqueue(ProgramPoint programPoint, ProgramState programState, @Nullable MethodYield methodYield) {
        this.enqueue(programPoint, programState, false, methodYield);
    }

    public void enqueue(ProgramPoint newProgramPoint, ProgramState programState, boolean exitPath) {
        this.enqueue(newProgramPoint, programState, exitPath, null);
    }

    public void enqueue(ProgramPoint newProgramPoint, ProgramState programState, boolean exitPath, @Nullable MethodYield methodYield) {
        ProgramPoint programPoint = newProgramPoint;
        int nbOfExecution = programState.numberOfTimeVisited(programPoint);
        if (nbOfExecution > 2) {
            if (ExplodedGraphWalker.isRestartingForEachLoop(programPoint)) {
                programPoint = new ProgramPoint(((CFG.Block)programPoint.block).falseBlock());
            } else {
                return;
            }
        }
        this.checkExplodedGraphTooBig(programState);
        ProgramState ps = programState.visitedPoint(programPoint, nbOfExecution + 1);
        ExplodedGraph.Node cachedNode = this.explodedGraph.node(programPoint, ps);
        if (!cachedNode.isNew() && exitPath == cachedNode.exitPath) {
            cachedNode.addParent(this.node, methodYield);
            return;
        }
        cachedNode.exitPath = exitPath;
        cachedNode.addParent(this.node, methodYield);
        this.workList.addFirst(cachedNode);
    }

    private static boolean isRestartingForEachLoop(ProgramPoint programPoint) {
        Tree terminator = ((CFG.Block)programPoint.block).terminator();
        return terminator != null && terminator.is(Tree.Kind.FOR_EACH_STATEMENT);
    }

    private void checkExplodedGraphTooBig(ProgramState programState) {
        if (this.steps + this.workList.size() > this.maxSteps() / 2 && programState.constraintsSize() > 75) {
            throw new ExplodedGraphTooBigException("Program state constraints are too big : stopping Symbolic Execution for method " + this.methodTree.simpleName().name() + " in class " + this.methodTree.symbol().owner().name());
        }
    }

    @VisibleForTesting
    protected int maxSteps() {
        return 16000;
    }

    AlwaysTrueOrFalseExpressionCollector alwaysTrueOrFalseExpressionCollector() {
        return this.alwaysTrueOrFalseExpressionCollector;
    }

    @CheckForNull
    protected MethodBehavior peekMethodBehavior(Symbol.MethodSymbol symbol) {
        return this.behaviorCache.peek(symbol.signature());
    }

    public static class ExplodedGraphWalkerFactory {
        @VisibleForTesting
        final List<SECheck> seChecks = new ArrayList<SECheck>();

        public ExplodedGraphWalkerFactory(List<JavaCheck> scanners) {
            List<SECheck> checks = scanners.stream().filter(SECheck.class::isInstance).map(SECheck.class::cast).collect(Collectors.toList());
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NullDereferenceCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new DivisionByZeroCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new UnclosedResourcesCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new LocksNotUnlockedCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NonNullSetToNullCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NoWayOutLoopCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new OptionalGetBeforeIsPresentCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new StreamConsumedCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new RedundantAssignmentsCheck()));
            this.seChecks.addAll(checks);
        }

        public ExplodedGraphWalker createWalker(BehaviorCache behaviorCache, Sema semanticModel) {
            return new ExplodedGraphWalker(this.seChecks, behaviorCache, semanticModel);
        }

        private static <T extends SECheck> T removeOrDefault(List<SECheck> checks, T defaultInstance) {
            Iterator<SECheck> iterator = checks.iterator();
            while (iterator.hasNext()) {
                SECheck check = iterator.next();
                if (!check.getClass().equals(defaultInstance.getClass())) continue;
                iterator.remove();
                return (T)check;
            }
            return defaultInstance;
        }
    }

    public static class MaximumStartingStatesException
    extends RuntimeException {
        public MaximumStartingStatesException(String s) {
            super(s);
        }
    }

    public static class TooManyNestedBooleanStatesException
    extends RuntimeException {
    }

    public static class MaximumStepsReachedException
    extends RuntimeException {
        public MaximumStepsReachedException(String s) {
            super(s);
        }

        public MaximumStepsReachedException(String s, RuntimeException e) {
            super(s, e);
        }
    }

    public static class ExplodedGraphTooBigException
    extends RuntimeException {
        public ExplodedGraphTooBigException(String s) {
            super(s);
        }
    }
}

