/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.sonar.api.Plugin;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.Version;
import org.sonar.java.AnalysisWarningsWrapper;
import org.sonar.java.DefaultJavaResourceLocator;
import org.sonar.java.SonarComponents;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForMainForSonarLint;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.java.classpath.ClasspathProperties;
import org.sonar.java.filters.PostAnalysisIssueFilter;
import org.sonar.java.jsp.Jasper;
import org.sonar.plugins.java.DroppedPropertiesSensor;
import org.sonar.plugins.java.ExternalReportExtensions;
import org.sonar.plugins.java.Java;
import org.sonar.plugins.java.JavaRulesDefinition;
import org.sonar.plugins.java.JavaSonarWayProfile;
import org.sonar.plugins.java.JavaSquidSensor;
import org.sonar.plugins.java.XmlFileSensor;
import org.sonar.plugins.surefire.SurefireExtensions;

public class JavaPlugin
implements Plugin {
    public void define(Plugin.Context context) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (context.getRuntime().getProduct() == SonarProduct.SONARLINT) {
            list.add(ClasspathForMainForSonarLint.class);
        } else {
            list.addAll(SurefireExtensions.getExtensions());
            list.add(DroppedPropertiesSensor.class);
            list.add(JavaSonarWayProfile.class);
            list.add(ClasspathForMain.class);
            ExternalReportExtensions.define(context);
        }
        if (JavaPlugin.supportJspTranspilation(context)) {
            list.add(Jasper.class);
        }
        list.addAll(ClasspathProperties.getProperties());
        list.addAll(Arrays.asList(ClasspathForTest.class, Java.class, PropertyDefinition.builder((String)"sonar.java.file.suffixes").defaultValue(".java,.jav").category("java").name("File suffixes").multiValues(true).description("Comma-separated list of suffixes for files to analyze. To not filter, leave the list empty.").subCategory("General").onQualifiers("TRK", new String[0]).build(), JavaRulesDefinition.class, SonarComponents.class, DefaultJavaResourceLocator.class, JavaSquidSensor.class, PostAnalysisIssueFilter.class, XmlFileSensor.class));
        list.add(AnalysisWarningsWrapper.class);
        context.addExtensions(Collections.unmodifiableList(list));
    }

    private static boolean supportJspTranspilation(Plugin.Context context) {
        if (context.getRuntime().getProduct() != SonarProduct.SONARQUBE) {
            return false;
        }
        SonarEdition edition = context.getRuntime().getEdition();
        boolean greaterThan83 = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)8, (int)3));
        return edition != SonarEdition.COMMUNITY && greaterThan83;
    }
}

