/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaSquid;
import org.sonar.java.Measurer;
import org.sonar.java.PerformanceMeasure;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.java.filters.PostAnalysisIssueFilter;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.jsp.Jasper;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;

@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(JavaSquidSensor.class);
    private final SonarComponents sonarComponents;
    private final FileSystem fs;
    private final JavaResourceLocator javaResourceLocator;
    private final Configuration settings;
    private final NoSonarFilter noSonarFilter;
    @Nullable
    private final Jasper jasper;
    private final PostAnalysisIssueFilter postAnalysisIssueFilter;

    public JavaSquidSensor(SonarComponents sonarComponents, FileSystem fs, JavaResourceLocator javaResourceLocator, Configuration settings, NoSonarFilter noSonarFilter, PostAnalysisIssueFilter postAnalysisIssueFilter) {
        this(sonarComponents, fs, javaResourceLocator, settings, noSonarFilter, postAnalysisIssueFilter, null);
    }

    public JavaSquidSensor(SonarComponents sonarComponents, FileSystem fs, JavaResourceLocator javaResourceLocator, Configuration settings, NoSonarFilter noSonarFilter, PostAnalysisIssueFilter postAnalysisIssueFilter, @Nullable Jasper jasper) {
        this.noSonarFilter = noSonarFilter;
        this.sonarComponents = sonarComponents;
        this.fs = fs;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
        this.postAnalysisIssueFilter = postAnalysisIssueFilter;
        this.jasper = jasper;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JavaSquidSensor");
    }

    public void execute(SensorContext context) {
        PerformanceMeasure.DurationReport sensorDuration = PerformanceMeasure.start(context.config(), "JavaSquidSensor", System::nanoTime);
        this.sonarComponents.setSensorContext(context);
        this.sonarComponents.registerCheckClasses("java", CheckList.getJavaChecks());
        this.sonarComponents.registerTestCheckClasses("java", CheckList.getJavaTestChecks());
        Measurer measurer = new Measurer(context, this.noSonarFilter);
        JavaSquid squid = new JavaSquid(this.getJavaVersion(), this.sonarComponents, measurer, this.javaResourceLocator, (SonarJavaIssueFilter)this.postAnalysisIssueFilter, new SymbolicExecutionVisitor(Arrays.asList(this.sonarComponents.checkClasses())), this.sonarComponents.checkClasses());
        squid.scan(this.getSourceFiles(), this.getTestFiles(), this.runJasper(context));
        sensorDuration.stopAndLog(context.fileSystem().workDir(), true);
    }

    private Collection<GeneratedFile> runJasper(SensorContext context) {
        return this.jasper != null ? this.jasper.generateFiles(context, this.sonarComponents.getJavaClasspath()) : Collections.emptyList();
    }

    private Iterable<InputFile> getSourceFiles() {
        return this.javaFiles(InputFile.Type.MAIN);
    }

    private Iterable<InputFile> getTestFiles() {
        return this.javaFiles(InputFile.Type.TEST);
    }

    private Iterable<InputFile> javaFiles(InputFile.Type type) {
        return this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(type)));
    }

    private JavaVersion getJavaVersion() {
        JavaVersion javaVersion = JavaVersionImpl.fromString(this.settings.get("sonar.java.source").orElse(null));
        LOG.info("Configured Java source version (sonar.java.source): " + javaVersion);
        return javaVersion;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

