/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.Transports;

public class ClusterConnectionManager
implements ConnectionManager {
    private static final Logger logger = LogManager.getLogger(ClusterConnectionManager.class);
    private final ConcurrentMap<DiscoveryNode, Transport.Connection> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<DiscoveryNode, ListenableFuture<Void>> pendingConnections = ConcurrentCollections.newConcurrentMap();
    private final AbstractRefCounted connectingRefCounter = new AbstractRefCounted("connection manager"){

        protected void closeInternal() {
            Iterator iterator = ClusterConnectionManager.this.connectedNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                try {
                    IOUtils.closeWhileHandlingException((Closeable)((Closeable)next.getValue()));
                }
                finally {
                    iterator.remove();
                }
            }
            ClusterConnectionManager.this.closeLatch.countDown();
        }
    };
    private final Transport transport;
    private final ConnectionProfile defaultProfile;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final ConnectionManager.DelegatingNodeConnectionListener connectionListener = new ConnectionManager.DelegatingNodeConnectionListener();

    public ClusterConnectionManager(Settings settings, Transport transport) {
        this(ConnectionProfile.buildDefaultConnectionProfile(settings), transport);
    }

    public ClusterConnectionManager(ConnectionProfile connectionProfile, Transport transport) {
        this.transport = transport;
        this.defaultProfile = connectionProfile;
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.connectionListener.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.connectionListener.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        this.internalOpenConnection(node, resolvedProfile, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        if (node == null) {
            listener.onFailure(new ConnectTransportException(null, "can't connect to a null node"));
            return;
        }
        if (!this.connectingRefCounter.tryIncRef()) {
            listener.onFailure(new IllegalStateException("connection manager is closed"));
            return;
        }
        if (this.connectedNodes.containsKey(node)) {
            this.connectingRefCounter.decRef();
            listener.onResponse(null);
            return;
        }
        ListenableFuture<Void> currentListener = new ListenableFuture<Void>();
        ListenableFuture<Void> existingListener = this.pendingConnections.putIfAbsent(node, currentListener);
        if (existingListener != null) {
            try {
                existingListener.addListener(listener, EsExecutors.newDirectExecutorService());
            }
            finally {
                this.connectingRefCounter.decRef();
            }
            return;
        }
        currentListener.addListener(listener, EsExecutors.newDirectExecutorService());
        RunOnce releaseOnce = new RunOnce(() -> ((AbstractRefCounted)this.connectingRefCounter).decRef());
        this.internalOpenConnection(node, resolvedProfile, ActionListener.wrap(conn -> connectionValidator.validate((Transport.Connection)conn, resolvedProfile, ActionListener.wrap(ignored -> {
            block9: {
                assert (Transports.assertNotTransportThread("connection validator success"));
                try {
                    if (this.connectedNodes.putIfAbsent(node, (Transport.Connection)conn) != null) {
                        logger.debug("existing connection to node [{}], closing new redundant connection", (Object)node);
                        IOUtils.closeWhileHandlingException((Closeable)conn);
                        break block9;
                    }
                    logger.debug("connected to node [{}]", (Object)node);
                    try {
                        this.connectionListener.onNodeConnected(node, (Transport.Connection)conn);
                    }
                    finally {
                        Transport.Connection finalConnection = conn;
                        conn.addCloseListener(ActionListener.wrap(() -> {
                            logger.trace("unregistering {} after connection close and marking as disconnected", (Object)node);
                            this.connectedNodes.remove(node, finalConnection);
                            this.connectionListener.onNodeDisconnected(node, (Transport.Connection)conn);
                        }));
                    }
                }
                finally {
                    ListenableFuture future = (ListenableFuture)this.pendingConnections.remove(node);
                    assert (future == currentListener) : "Listener in pending map is different than the expected listener";
                    releaseOnce.run();
                    future.onResponse(null);
                }
            }
        }, e -> {
            assert (Transports.assertNotTransportThread("connection validator failure"));
            IOUtils.closeWhileHandlingException((Closeable)conn);
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        })), e -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection failure"));
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        }));
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
        if (connection == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return connection;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        Transport.Connection nodeChannels = (Transport.Connection)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            nodeChannels.close();
        }
    }

    @Override
    public int size() {
        return this.connectedNodes.size();
    }

    @Override
    public Set<DiscoveryNode> getAllConnectedNodes() {
        return Collections.unmodifiableSet(this.connectedNodes.keySet());
    }

    @Override
    public void close() {
        this.internalClose(true);
    }

    @Override
    public void closeNoBlock() {
        this.internalClose(false);
    }

    private void internalClose(boolean waitForPendingConnections) {
        assert (Transports.assertNotTransportThread("Closing ConnectionManager"));
        if (this.closing.compareAndSet(false, true)) {
            this.connectingRefCounter.decRef();
            if (waitForPendingConnections) {
                try {
                    this.closeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void internalOpenConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        this.transport.openConnection(node, connectionProfile, listener.map(connection -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection success"));
            try {
                this.connectionListener.onConnectionOpened((Transport.Connection)connection);
            }
            finally {
                connection.addCloseListener(ActionListener.wrap(() -> this.connectionListener.onConnectionClosed((Transport.Connection)connection)));
            }
            if (connection.isClosed()) {
                throw new ConnectTransportException(node, "a channel closed while connecting");
            }
            return connection;
        }));
    }

    private void failConnectionListeners(DiscoveryNode node, RunOnce releaseOnce, Exception e, ListenableFuture<Void> expectedListener) {
        ListenableFuture future = (ListenableFuture)this.pendingConnections.remove(node);
        releaseOnce.run();
        if (future != null) {
            assert (future == expectedListener) : "Listener in pending map is different than the expected listener";
            future.onFailure(e);
        }
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.defaultProfile;
    }
}

