/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.ParseErrorException;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

public class XmlParserHelper
implements AutoCloseable {
    private static final Logger LOG = Loggers.get(XmlParserHelper.class);
    private final File file;
    private final InputStreamReader reader;
    private final XMLStreamReader stream;

    XmlParserHelper(File file) {
        try {
            this.file = file;
            this.reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            this.stream = this.createXmlStreamReader();
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    void checkRootTag(String name) {
        String rootTag = this.nextStartTag();
        if (!name.equals(rootTag)) {
            throw this.parseError("Missing root element <" + name + ">");
        }
    }

    @Nullable
    String nextStartTag() {
        try {
            while (this.stream.hasNext()) {
                if (this.getNextValid() != 1) continue;
                return this.stream.getLocalName();
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Error while parsing the XML file: " + this.file.getAbsolutePath(), e);
        }
    }

    private int getNextValid() throws XMLStreamException {
        Location lastLocation = this.stream.getLocation();
        while (this.stream.hasNext()) {
            try {
                return this.stream.next();
            }
            catch (XMLStreamException e) {
                Location currentLocation = this.stream.getLocation();
                if (XmlParserHelper.isSameLocation(lastLocation, currentLocation)) {
                    LOG.warn("Unable to get next XML event while parsing file '{}'", (Object)this.file.toString());
                    throw e;
                }
                lastLocation = currentLocation;
            }
        }
        return -1;
    }

    private static boolean isSameLocation(@Nullable Location loc1, @Nullable Location loc2) {
        return Objects.equals(loc1, loc2) || loc1 != null && loc2 != null && loc1.getLineNumber() == loc2.getLineNumber() && loc1.getColumnNumber() == loc2.getColumnNumber() && loc1.getCharacterOffset() == loc2.getCharacterOffset() && Objects.equals(loc1.getPublicId(), loc2.getPublicId()) && Objects.equals(loc1.getSystemId(), loc2.getSystemId());
    }

    @Nullable
    String nextStartOrEndTag() {
        try {
            while (this.stream.hasNext()) {
                int next = this.stream.next();
                if (next == 1) {
                    return "<" + this.stream.getLocalName() + ">";
                }
                if (next != 2) continue;
                return "</" + this.stream.getLocalName() + ">";
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Error while parsing the XML file: " + this.file.getAbsolutePath(), e);
        }
    }

    void checkRequiredAttribute(String name, int expectedValue) {
        int actualValue = this.getRequiredIntAttribute(name);
        if (expectedValue != actualValue) {
            throw this.parseError("Expected \"" + expectedValue + "\" instead of \"" + actualValue + "\" for the \"" + name + "\" attribute");
        }
    }

    int getRequiredIntAttribute(String name) {
        String value = this.getRequiredAttribute(name);
        return this.tagToIntValue(name, value);
    }

    int getIntAttributeOrZero(String name) {
        String value = this.getAttribute(name);
        return value == null ? 0 : this.tagToIntValue(name, value);
    }

    int tagToIntValue(String name, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.parseError("Expected an integer instead of \"" + value + "\" for the attribute \"" + name + "\"");
        }
    }

    @Nullable
    Double getDoubleAttribute(String name) {
        String value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        try {
            value = value.replace(',', '.');
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw this.parseError("Expected an double instead of \"" + value + "\" for the attribute \"" + name + "\"");
        }
    }

    String getRequiredAttribute(String name) {
        String value = this.getAttribute(name);
        if (value == null) {
            throw this.parseError("Missing attribute \"" + name + "\" in element <" + this.stream.getLocalName() + ">");
        }
        return value;
    }

    @Nullable
    String getAttribute(String name) {
        for (int i = 0; i < this.stream.getAttributeCount(); ++i) {
            if (!name.equals(this.stream.getAttributeLocalName(i))) continue;
            return this.stream.getAttributeValue(i);
        }
        return null;
    }

    ParseErrorException parseError(String message) {
        return new ParseErrorException(message + " in " + this.file.getAbsolutePath() + " at line " + this.stream.getLocation().getLineNumber());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    XMLStreamReader stream() {
        return this.stream;
    }

    XMLStreamReader createXmlStreamReader() throws XMLStreamException {
        return SafetyFactory.createXMLInputFactory().createXMLStreamReader(this.reader);
    }
}

