/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.TokenLocation;

public abstract class IssueLocation {
    public static final int UNDEFINED_OFFSET = -1;
    public static final int UNDEFINED_LINE = 0;
    private String message;

    private IssueLocation(@Nullable String message) {
        this.message = message;
    }

    public static IssueLocation atFileLevel(String message) {
        return new FileLevelIssueLocation(message);
    }

    public static IssueLocation atLineLevel(String message, int lineNumber) {
        return new LineLevelIssueLocation(message, lineNumber);
    }

    public static IssueLocation preciseLocation(Tree tree, @Nullable String message) {
        return new PreciseIssueLocation(tree.firstToken(), tree.lastToken(), message);
    }

    public static IssueLocation preciseLocation(Token token, @Nullable String message) {
        return new PreciseIssueLocation(token, message);
    }

    public static IssueLocation preciseLocation(Token from, Token to, @Nullable String message) {
        return new PreciseIssueLocation(from, to, message);
    }

    public static IssueLocation preciseLocation(LocationInFile locationInFile, @Nullable String message) {
        return new PreciseIssueLocation(locationInFile, message);
    }

    @CheckForNull
    public String message() {
        return this.message;
    }

    public abstract int startLine();

    public abstract int startLineOffset();

    public abstract int endLine();

    public abstract int endLineOffset();

    @CheckForNull
    public abstract String fileId();

    private static class FileLevelIssueLocation
    extends IssueLocation {
        public FileLevelIssueLocation(String message) {
            super(message);
        }

        @Override
        public int startLine() {
            return 0;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return 0;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }

        @Override
        public String fileId() {
            return null;
        }
    }

    private static class LineLevelIssueLocation
    extends IssueLocation {
        private final int lineNumber;

        public LineLevelIssueLocation(String message, int lineNumber) {
            super(message);
            this.lineNumber = lineNumber;
        }

        @Override
        public int startLine() {
            return this.lineNumber;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return this.lineNumber;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }

        @Override
        public String fileId() {
            return null;
        }
    }

    private static class PreciseIssueLocation
    extends IssueLocation {
        @CheckForNull
        private final String fileId;
        private final int startLine;
        private final int startLineOffset;
        private final int endLine;
        private final int endLineOffset;

        public PreciseIssueLocation(Token firstToken, Token lastToken, @Nullable String message) {
            super(message);
            this.startLine = firstToken.line();
            this.startLineOffset = firstToken.column();
            TokenLocation tokenLocation = new TokenLocation(lastToken);
            this.endLine = tokenLocation.endLine();
            this.endLineOffset = tokenLocation.endLineOffset();
            this.fileId = null;
        }

        public PreciseIssueLocation(Token token, @Nullable String message) {
            this(token, token, message);
        }

        public PreciseIssueLocation(LocationInFile locationInFile, @Nullable String message) {
            super(message);
            this.startLine = locationInFile.startLine();
            this.startLineOffset = locationInFile.startLineOffset();
            this.endLine = locationInFile.endLine();
            this.endLineOffset = locationInFile.endLineOffset();
            this.fileId = locationInFile.fileId();
        }

        @Override
        public int startLine() {
            return this.startLine;
        }

        @Override
        public int startLineOffset() {
            return this.startLineOffset;
        }

        @Override
        public int endLine() {
            return this.endLine;
        }

        @Override
        public int endLineOffset() {
            return this.endLineOffset;
        }

        @Override
        public String fileId() {
            return this.fileId;
        }
    }
}

